/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui;

import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.screen.edit.ContainerEditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.PlayerEditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.gui.widget.MatchTransferButton;
import dev.terminalmc.clientsort.client.gui.widget.SortButton;
import dev.terminalmc.clientsort.client.gui.widget.StackFillButton;
import dev.terminalmc.clientsort.client.gui.widget.TransferButton;
import dev.terminalmc.clientsort.client.gui.widget.TriggerButton;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.util.Scope;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.mixin.client.accessor.ScreenAccessor;
import dev.terminalmc.clientsort.util.Localization;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1724;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class TriggerButtonManager {
    private static final int BUTTON_SPACING = 1;
    private static final int BUTTON_SHIFT_X = 0;
    private static final int BUTTON_SHIFT_Y = 1;
    private static final LinkedHashSet<TriggerButton> containerButtons = new LinkedHashSet();
    private static final LinkedHashSet<TriggerButton> playerButtons = new LinkedHashSet();

    private TriggerButtonManager() {
    }

    public static LinkedList<TriggerButton> getContainerButtons() {
        return new LinkedList<TriggerButton>(containerButtons);
    }

    public static LinkedList<TriggerButton> getPlayerButtons() {
        return new LinkedList<TriggerButton>(playerButtons);
    }

    public static void afterScreenInit(class_437 screen) {
        class_1735 playerRefSlot;
        if (!(screen instanceof class_465)) {
            return;
        }
        class_465 acs = (class_465)screen;
        containerButtons.clear();
        playerButtons.clear();
        if (!Config.options().showButtons) {
            return;
        }
        boolean forceShowContainer = false;
        boolean forceShowPlayer = false;
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof SelectorScreen) {
            forceShowContainer = true;
            forceShowPlayer = true;
        } else if (currentScreen instanceof ContainerEditorScreen) {
            forceShowContainer = true;
        } else if (currentScreen instanceof PlayerEditorScreen) {
            forceShowPlayer = true;
        }
        class_1735 containerRefSlot = TriggerButtonManager.getReferenceSlot(acs, false);
        if (containerRefSlot != null) {
            TriggerButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().firstButtonOp);
            TriggerButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().secondButtonOp);
            TriggerButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().thirdButtonOp);
            TriggerButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().fourthButtonOp);
        }
        if ((playerRefSlot = TriggerButtonManager.getReferenceSlot(acs, true)) != null) {
            TriggerButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().firstButtonOp);
            TriggerButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().secondButtonOp);
            TriggerButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().thirdButtonOp);
            TriggerButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().fourthButtonOp);
        }
    }

    private static void generate(class_465<?> screen, class_1735 refSlot, boolean isPlayerInv, boolean forceShow, Operation op) {
        switch (op) {
            case SORT: {
                TriggerButtonManager.generateSortButton(screen, refSlot, isPlayerInv, forceShow);
                break;
            }
            case STACK_FILL: {
                TriggerButtonManager.generateStackFillButton(screen, refSlot, isPlayerInv, forceShow);
                break;
            }
            case MATCH_TRANSFER: {
                TriggerButtonManager.generateMatchTransferButton(screen, refSlot, isPlayerInv, forceShow);
                break;
            }
            case TRANSFER: {
                TriggerButtonManager.generateTransferButton(screen, refSlot, isPlayerInv, forceShow);
            }
        }
    }

    private static void generateSortButton(class_465<?> screen, class_1735 referenceSlot, boolean isPlayerInv, boolean forceShow) {
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInv) {
            return;
        }
        if (TriggerButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        @Nullable Object container = isPlayerInv ? player.method_31548() : TriggerButtonManager.getContainer((class_1657)player);
        Object object = ClientSort.getObj((class_1263)container, screen.method_17577());
        if (object == null) {
            return;
        }
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
        if (!(policy != null && policy.showSortButton() || forceShow)) {
            return;
        }
        Vec2i offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        SortButton button = new SortButton(screen, (class_1263)container, referenceSlot, isPlayerInv, policy, object.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv), (class_2561)Localization.localized("key", "op.sort", new Object[0]));
        TriggerButtonManager.addButton(screen, button, isPlayerInv);
    }

    private static void generateStackFillButton(class_465<?> screen, class_1735 referenceSlot, boolean isPlayerInv, boolean forceShow) {
        class_1263 dstContainer;
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInv) {
            return;
        }
        if (TriggerButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        @Nullable Object container = isPlayerInv ? player.method_31548() : TriggerButtonManager.getContainer((class_1657)player);
        Object object = ClientSort.getObj((class_1263)container, screen.method_17577());
        if (object == null) {
            return;
        }
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
        if (!(policy != null && policy.showStackFillButton() || forceShow)) {
            return;
        }
        Vec2i offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        Object object2 = dstContainer = isPlayerInv ? TriggerButtonManager.getContainer((class_1657)player) : player.method_31548();
        if (dstContainer != null) {
            Object dstObject = ClientSort.getObj(dstContainer, screen.method_17577());
            if (dstObject == null) {
                return;
            }
            @Nullable ClassPolicy dstPolicy = PolicyManager.getPolicy(dstObject.getClass());
            if (!(dstPolicy != null && dstPolicy.showStackFillButton() || forceShow)) {
                return;
            }
        }
        StackFillButton button = new StackFillButton(screen, (class_1263)container, referenceSlot, isPlayerInv, policy, object.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv), (class_2561)Localization.localized("key", "op.stackFill", new Object[0]));
        TriggerButtonManager.addButton(screen, button, isPlayerInv);
    }

    private static void generateMatchTransferButton(class_465<?> screen, class_1735 referenceSlot, boolean isPlayerInv, boolean forceShow) {
        class_1263 dstContainer;
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInv) {
            return;
        }
        if (TriggerButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        @Nullable Object container = isPlayerInv ? player.method_31548() : TriggerButtonManager.getContainer((class_1657)player);
        Object object = ClientSort.getObj((class_1263)container, screen.method_17577());
        if (object == null) {
            return;
        }
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
        if (!(policy != null && policy.showMatchTransferButton() || forceShow)) {
            return;
        }
        Vec2i offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        Object object2 = dstContainer = isPlayerInv ? TriggerButtonManager.getContainer((class_1657)player) : player.method_31548();
        if (dstContainer != null) {
            Object dstObject = ClientSort.getObj(dstContainer, screen.method_17577());
            if (dstObject == null) {
                return;
            }
            @Nullable ClassPolicy dstPolicy = PolicyManager.getPolicy(dstObject.getClass());
            if (!(dstPolicy != null && dstPolicy.showMatchTransferButton() || forceShow)) {
                return;
            }
        }
        MatchTransferButton button = new MatchTransferButton(screen, (class_1263)container, referenceSlot, isPlayerInv, policy, object.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv), (class_2561)Localization.localized("key", "op.matchTransfer", new Object[0]));
        TriggerButtonManager.addButton(screen, button, isPlayerInv);
    }

    private static void generateTransferButton(class_465<?> screen, class_1735 referenceSlot, boolean isPlayerInv, boolean forceShow) {
        class_1263 dstContainer;
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInv) {
            return;
        }
        if (TriggerButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        @Nullable Object container = isPlayerInv ? player.method_31548() : TriggerButtonManager.getContainer((class_1657)player);
        Object object = ClientSort.getObj((class_1263)container, screen.method_17577());
        if (object == null) {
            return;
        }
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
        if (!(policy != null && policy.showTransferButton() || forceShow)) {
            return;
        }
        Vec2i offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        Object object2 = dstContainer = isPlayerInv ? TriggerButtonManager.getContainer((class_1657)player) : player.method_31548();
        if (dstContainer != null) {
            Object dstObject = ClientSort.getObj(dstContainer, screen.method_17577());
            if (dstObject == null) {
                return;
            }
            @Nullable ClassPolicy dstPolicy = PolicyManager.getPolicy(dstObject.getClass());
            if (!(dstPolicy != null && dstPolicy.showTransferButton() || forceShow)) {
                return;
            }
        }
        TransferButton button = new TransferButton(screen, (class_1263)container, referenceSlot, isPlayerInv, policy, object.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv), (class_2561)Localization.localized("key", "op.transfer", new Object[0]));
        TriggerButtonManager.addButton(screen, button, isPlayerInv);
    }

    @Nullable
    public static class_1263 getContainer(class_1657 player) {
        try {
            return player.field_7512.method_7611((int)0).field_7871;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static void addButton(class_465<?> screen, TriggerButton button, boolean isPlayerInv) {
        ((ScreenAccessor)screen).clientsort$addRenderableWidget(button);
        (isPlayerInv ? playerButtons : containerButtons).add(button);
    }

    @Nullable
    private static class_1735 getReferenceSlot(class_465<?> screen, boolean isPlayerInv) {
        ContainerScreenHelper<class_465<?>> helper = ContainerScreenHelper.of(screen);
        return screen.method_17577().field_7761.stream().filter(slot -> isPlayerInv ? slot.field_7871 instanceof class_1661 && helper.getScope((class_1735)slot).equals((Object)Scope.PLAYER_INV) : !(slot.field_7871 instanceof class_1661) && helper.getScope((class_1735)slot).equals((Object)Scope.CONTAINER_INV)).max(Comparator.comparingInt(slot -> slot.field_7873 * 9999 - slot.field_7872)).orElse(null);
    }

    private static int getNumberOfBulkInventorySlots(class_465<?> screen, boolean isPlayerInv) {
        return screen.method_17577().field_7761.stream().filter(slot -> isPlayerInv == slot.field_7871 instanceof class_1661).filter(slot -> !(screen.method_17577() instanceof class_1724) || ((ISlot)slot).clientsort$getIndexInContainer() >= 2).mapToInt(slot -> 1).sum();
    }

    public static Vec2i getShiftedOffset(Vec2i offset, boolean isPlayerInv) {
        int index = (isPlayerInv ? playerButtons : containerButtons).size();
        int x = offset.x() + 0 * index;
        int y = offset.y() + 14 * index;
        return new Vec2i(x, y);
    }
}

