/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.client;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientOperator;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.util.SoundManager;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_465;

public class ClientCreativeOperator<T extends Operation>
extends ClientOperator<Operation> {
    public ClientCreativeOperator(class_465<?> screen, ContainerScreenHelper<? extends class_465<?>> screenHelper, class_1735 originSlot, T operation) {
        super(screen, screenHelper, originSlot, operation);
    }

    @Override
    protected void collect() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation COLLECT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation COLLECT", new Object[0]);
        }
        block0: for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            class_1735 srcSlot = this.originScopeSlots[i];
            class_1799 srcStack = this.originScopeStacks[i];
            if (srcStack.method_7960() || srcStack.method_7947() >= srcSlot.method_7676(srcStack)) continue;
            for (int j = 0; j < i; ++j) {
                class_1735 dstSlot = this.originScopeSlots[j];
                class_1799 dstStack = this.originScopeStacks[j];
                if (dstStack.method_7960() || dstStack.method_7947() >= dstSlot.method_7676(dstStack) || !class_1799.method_31577((class_1799)srcStack, (class_1799)dstStack)) continue;
                int delta = dstSlot.method_7676(dstStack) - dstStack.method_7947();
                delta = Math.min(delta, srcStack.method_7947());
                srcStack.method_7934(delta);
                dstStack.method_7933(delta);
                int srcSlotId = ((ISlot)srcSlot).clientsort$getIndexInMenu();
                int dstSlotId = ((ISlot)dstSlot).clientsort$getIndexInMenu();
                InteractionManager.push(() -> {
                    class_310.method_1551().field_1761.method_2909(srcStack.method_7972(), srcSlotId);
                    class_310.method_1551().field_1761.method_2909(dstStack.method_7972(), dstSlotId);
                    return InteractionManager.TICK_WAITER;
                });
                if (srcStack.method_7947() <= 0) continue block0;
            }
        }
        InteractionManager.push(() -> {
            class_310.method_1551().field_1724.field_7498.method_7623();
            if (ClientSort.debug()) {
                ClientSort.LOG.info("Finished operation COLLECT", new Object[0]);
            }
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void sort(int[] key, boolean playSound) {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation SORT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation SORT", new Object[0]);
        }
        for (int i = 0; i < key.length; ++i) {
            class_1799 srcItem = this.originScopeStacks[key[i]];
            class_1799 dstItem = this.originScopeStacks[i];
            if (srcItem.method_7960() && dstItem.method_7960()) continue;
            int dstSlotId = ((ISlot)this.originScopeSlots[i]).clientsort$getIndexInMenu();
            InteractionManager.push(() -> {
                class_310.method_1551().field_1724.field_7498.method_7611(dstSlotId).method_7673(srcItem);
                class_310.method_1551().field_1761.method_2909(srcItem, dstSlotId);
                if (playSound) {
                    SoundManager.play();
                }
                return InteractionManager.TICK_WAITER;
            });
        }
        InteractionManager.push(() -> {
            class_310.method_1551().field_1724.field_7498.method_7623();
            if (ClientSort.debug()) {
                ClientSort.LOG.info("Finished operation SORT", new Object[0]);
            }
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void fillStacks() {
        if (ClientSort.debug()) {
            ClientSort.LOG.warn("Operation STACK_FILL is not supported by {}", this.getClass().getSimpleName());
        }
    }

    @Override
    protected void matchTransfer() {
        if (ClientSort.debug()) {
            ClientSort.LOG.warn("Operation MATCH_TRANSFER is not supported by {}", this.getClass().getSimpleName());
        }
    }

    @Override
    protected void transfer() {
        if (ClientSort.debug()) {
            ClientSort.LOG.warn("Operation TRANSFER is not supported by {}", this.getClass().getSimpleName());
        }
    }
}

