/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.PayloadHandler;
import dev.terminalmc.clientsort.network.handler.validate.PolicyManager;
import dev.terminalmc.clientsort.network.handler.validate.SchemaValidator;
import dev.terminalmc.clientsort.network.payload.SortPayload;
import dev.terminalmc.clientsort.network.payload.SortResultPayload;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.TreeMap;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SortHandler
extends PayloadHandler {
    private SortHandler() {
    }

    public static void handle(SortPayload payload, MinecraftServer server, class_3222 player) {
        server.execute(() -> SortHandler.processPayload(server, player, payload.containerId(), menu -> SortHandler.checkPolicy(player, menu, payload.slotMapping()), menu -> SchemaValidator.validateSlotMapping(player, menu, payload.slotMapping()), menu -> SortHandler.sort(menu, payload.slotMapping()), SortPayload.TYPE, SortResultPayload.TYPE, (result, message) -> new SortResultPayload(result.code, (String)message)));
    }

    private static void sort(class_1703 menu, int[] slotMapping) throws PayloadHandlerException {
        TreeMap<Integer, class_1799> stacks = new TreeMap<Integer, class_1799>();
        for (class_1735 slot : menu.field_7761) {
            stacks.put(((ISlot)slot).clientsort$getIndexInMenu(), slot.method_7677().method_7972());
        }
        for (int i = 0; i < slotMapping.length - 1; i += 2) {
            int srcSlotId = slotMapping[i];
            int dstSlotId = slotMapping[i + 1];
            class_1735 dstSlot = (class_1735)menu.field_7761.get(dstSlotId);
            if (srcSlotId == dstSlotId) continue;
            dstSlot.method_53512((class_1799)stacks.get(srcSlotId));
            if (!SortHandler.notEqual(dstSlot.method_7677(), (class_1799)stacks.get(srcSlotId))) continue;
            for (int j = 0; j <= i; j += 2) {
                srcSlotId = slotMapping[j];
                ((class_1735)menu.field_7761.get(srcSlotId)).method_7673((class_1799)stacks.get(srcSlotId));
                dstSlotId = slotMapping[j + 1];
                ((class_1735)menu.field_7761.get(dstSlotId)).method_7673((class_1799)stacks.get(dstSlotId));
            }
            String message = String.format("Sort operation failed at slot mapping %d->%d: Expected '%s' in destination after set, got '%s'!", srcSlotId, dstSlotId, stacks.get(srcSlotId), dstSlot.method_7677());
            SortHandler.setPolicy(menu, slotMapping, message);
            throw new PayloadHandlerException.InconsistentStateException(message);
        }
    }

    private static void checkPolicy(class_3222 player, class_1703 menu, int[] slotIds) throws PayloadHandlerException.UnsupportedOpException {
        class_1703 object;
        class_1263 container = slotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)slotIds[0])).field_7871 : null;
        Object object2 = object = container instanceof class_1277 ? menu : container;
        if (container != player.method_31548()) {
            PolicyManager.checkPolicy(object.getClass(), bl -> bl.sortEnabled);
        }
    }

    private static void setPolicy(class_1703 menu, int[] slotIds, String message) {
        class_1263 container = slotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)slotIds[0])).field_7871 : null;
        class_1703 object = container instanceof class_1277 ? menu : container;
        PolicyManager.setPolicy(new ServerClassPolicy(object.getClass().getName(), false, true, true), SortPayload.ID.toString(), message);
    }
}

