/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.PayloadHandler;
import dev.terminalmc.clientsort.network.handler.validate.PolicyManager;
import dev.terminalmc.clientsort.network.handler.validate.SchemaValidator;
import dev.terminalmc.clientsort.network.payload.StackFillPayload;
import dev.terminalmc.clientsort.network.payload.StackFillResultPayload;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class StackFillHandler
extends PayloadHandler {
    private StackFillHandler() {
    }

    public static void handle(StackFillPayload payload, MinecraftServer server, class_3222 player) {
        server.execute(() -> StackFillHandler.processPayload(server, player, payload.srcContainerId(), menu -> StackFillHandler.checkPolicy(menu, payload.srcSlotIds(), payload.dstSlotIds()), menu -> {
            SchemaValidator.validateSlotArray(player, menu, payload.srcSlotIds());
            SchemaValidator.validateSlotArray(player, menu, payload.dstSlotIds());
        }, menu -> StackFillHandler.fillStacks(menu, payload.srcSlotIds(), payload.dstSlotIds()), StackFillPayload.TYPE, StackFillResultPayload.TYPE, (result, message) -> new StackFillResultPayload(result.code, (String)message)));
    }

    private static void fillStacks(class_1703 menu, int[] srcSlotIds, int[] dstSlotIds) throws PayloadHandlerException {
        block0: for (int i = srcSlotIds.length - 1; i >= 0; --i) {
            int srcSlotId = srcSlotIds[i];
            class_1735 srcSlot = (class_1735)menu.field_7761.get(srcSlotId);
            class_1799 srcStack = srcSlot.method_7677();
            class_1799 srcStackCopy = srcSlot.method_7677().method_7972();
            if (srcStack.method_7960()) continue;
            for (int dstSlotId : dstSlotIds) {
                class_1735 dstSlot = (class_1735)menu.field_7761.get(dstSlotId);
                class_1799 dstStack = dstSlot.method_7677();
                class_1799 dstStackCopy = dstSlot.method_7677().method_7972();
                if (dstStack.method_7960() || dstStack.method_7947() >= dstSlot.method_7676(dstStack) || !class_1799.method_31577((class_1799)srcStack, (class_1799)dstStack)) continue;
                class_1799 expected = srcStack.method_46651(Math.min(srcStack.method_7947() + dstStack.method_7947(), dstSlot.method_7676(dstStack)));
                dstSlot.method_32756(srcStack);
                if (StackFillHandler.notEqual(dstSlot.method_7677(), expected)) {
                    String message = String.format("Stack Fill operation failed to safe-insert from slot %d with item '%s' to slot %d with item '%s': Expected '%s' in destination after set, got '%s'!", srcSlotId, srcStackCopy, dstSlotId, dstStackCopy, expected, dstSlot.method_7677());
                    StackFillHandler.setPolicy(menu, dstSlotIds, message);
                    throw new PayloadHandlerException.InconsistentStateException(message);
                }
                if (srcStack.method_7960()) continue block0;
            }
        }
    }

    private static void checkPolicy(class_1703 menu, int[] srcSlotIds, int[] dstSlotIds) throws PayloadHandlerException.UnsupportedOpException {
        class_1263 srcContainer = srcSlotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)srcSlotIds[0])).field_7871 : null;
        class_1703 srcObject = srcContainer instanceof class_1277 ? menu : srcContainer;
        class_1263 dstContainer = dstSlotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)dstSlotIds[0])).field_7871 : null;
        class_1703 dstObject = dstContainer instanceof class_1277 ? menu : dstContainer;
        PolicyManager.checkPolicy(srcObject.getClass(), bl -> bl.stackFillEnabled);
        PolicyManager.checkPolicy(dstObject.getClass(), bl -> bl.stackFillEnabled);
    }

    private static void setPolicy(class_1703 menu, int[] dstSlotIds, String message) {
        class_1263 dstContainer = dstSlotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)dstSlotIds[0])).field_7871 : null;
        class_1703 object = dstContainer instanceof class_1277 ? menu : dstContainer;
        PolicyManager.setPolicy(new ServerClassPolicy(object.getClass().getName(), true, false, true), StackFillPayload.ID.toString(), message);
    }
}

