/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.helper;

import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.inventory.Scope;
import dev.terminalmc.clientsort.client.inventory.helper.CreativeContainerScreenHelper;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_485;
import net.minecraft.class_8181;

public class ContainerScreenHelper<T extends class_465<?>> {
    protected final T screen;

    protected ContainerScreenHelper(T screen) {
        this.screen = screen;
    }

    public static <T extends class_465<?>> ContainerScreenHelper<T> of(T screen) {
        if (screen instanceof class_481) {
            class_481 creativeScreen = (class_481)screen;
            return new CreativeContainerScreenHelper<class_481>(creativeScreen);
        }
        return new ContainerScreenHelper<T>(screen);
    }

    public static boolean isHotbarSlot(class_1735 slot) {
        return ((ISlot)slot).clientsort$getIndexInContainer() < 9;
    }

    public static boolean isExtraSlot(class_1735 slot) {
        return ((ISlot)slot).clientsort$getIndexInContainer() > 35;
    }

    public Scope getScope(class_1735 slot) {
        if (slot.field_7871 == null) {
            return Scope.INVALID;
        }
        if (slot.field_7871 instanceof class_8181) {
            return Scope.INVALID;
        }
        if (slot.method_55059()) {
            return Scope.INVALID;
        }
        if (this.screen instanceof class_485) {
            if (slot.field_7871 instanceof class_1661) {
                return ContainerScreenHelper.getScopeInInventory(slot);
            }
            return Scope.PLAYER_OTHER;
        }
        if (slot.field_7871 instanceof class_1661) {
            return ContainerScreenHelper.getScopeInInventory(slot);
        }
        return Scope.CONTAINER_INV;
    }

    private static Scope getScopeInInventory(class_1735 slot) {
        boolean mergeWithHotbar = false;
        if (ContainerScreenHelper.isExtraSlot(slot)) {
            switch (Config.options().extraSlotScope) {
                case HOTBAR: {
                    mergeWithHotbar = true;
                    break;
                }
                case EXTRA: {
                    return Scope.PLAYER_INV_EXTRA;
                }
                case NONE: {
                    return Scope.INVALID;
                }
            }
        }
        if (mergeWithHotbar || ContainerScreenHelper.isHotbarSlot(slot)) {
            switch (Config.options().hotbarScope) {
                case HOTBAR: {
                    return Scope.PLAYER_INV_HOTBAR;
                }
                case NONE: {
                    return Scope.INVALID;
                }
            }
        }
        return Scope.PLAYER_INV;
    }

    public List<class_1735> getLargestSlotGroup(Scope scope) {
        List<class_1735> slots = new ArrayList<class_1735>();
        for (List<class_1735> group : this.getSlotGroups(scope)) {
            if (group.size() <= slots.size()) continue;
            slots = group;
        }
        return slots;
    }

    public List<class_1735> getGroupForSlot(class_1735 slot, Scope scope) {
        if (scope == Scope.PLAYER_INV || scope == Scope.PLAYER_INV_HOTBAR) {
            List<class_1735> slots = this.getAllSlots(slot.field_7871, scope);
            if (slots.contains(slot)) {
                return slots;
            }
        } else {
            for (List<class_1735> group : this.getSlotGroups(scope)) {
                if (!group.contains(slot)) continue;
                return group;
            }
        }
        return new ArrayList<class_1735>();
    }

    public List<List<class_1735>> getSlotGroups(Scope scope) {
        ArrayList<List<class_1735>> slotGroups = new ArrayList<List<class_1735>>();
        ArrayList<class_1735> currentGroup = new ArrayList<class_1735>();
        int lastIdx = Integer.MAX_VALUE;
        class_1263 lastContainer = null;
        for (class_1735 slot : this.screen.method_17577().field_7761) {
            if (slot.field_7871 == null || !this.getScope(slot).equals((Object)scope)) continue;
            int slotIdx = ((ISlot)slot).clientsort$getIndexInContainer();
            if (slotIdx <= lastIdx || slot.field_7871 != lastContainer) {
                slotGroups.add(currentGroup);
                currentGroup = new ArrayList();
            }
            currentGroup.add(slot);
            lastIdx = slotIdx;
            lastContainer = slot.field_7871;
        }
        if (!currentGroup.isEmpty()) {
            slotGroups.add(currentGroup);
        }
        return slotGroups;
    }

    public List<class_1735> getAllSlots(class_1263 container, Scope scope) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        for (class_1735 slot : this.screen.method_17577().field_7761) {
            if (slot.field_7871 == null || !this.getScope(slot).equals((Object)scope) || slot.field_7871 != container) continue;
            slots.add(slot);
        }
        return slots;
    }

    public void translateSlotIds(int[] slotMapping) {
    }
}

