/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.compat.itemlocks.ItemLocksWrapper;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.gui.TriggerButtonManager;
import dev.terminalmc.clientsort.client.inventory.Scope;
import dev.terminalmc.clientsort.client.inventory.helper.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientCreativeOperator;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientSurvivalOperator;
import dev.terminalmc.clientsort.client.inventory.operator.server.ServerOperator;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.platform.ClientServices;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.util.SlotLogUtil;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public abstract class SingleUseOperator {
    private boolean hasOperated = false;
    protected final AbstractContainerScreen<?> screen;
    protected final ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper;
    protected final Operation op;
    protected final Slot originSlot;
    protected final Slot[] originScopeSlots;
    protected final ItemStack[] originScopeStacks;
    protected final Slot[] otherScopeSlots;
    protected final ItemStack[] otherScopeStacks;

    protected SingleUseOperator(AbstractContainerScreen<?> screen, Slot originSlot, Operation op) {
        Slot otherSlot;
        this.screen = screen;
        this.screenHelper = ContainerScreenHelper.of(screen);
        this.originSlot = originSlot;
        this.op = op;
        Scope originScope = this.screenHelper.getScope(originSlot);
        this.originScopeSlots = this.collectSlots(originSlot, originScope);
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Discovered {} slots in origin scope ({} - {}):", this.originScopeSlots.length, originScope.ordinal(), originScope.name());
            dev.terminalmc.clientsort.client.ClientSort.LOG.info(SlotLogUtil.listSlotIds(List.of(this.originScopeSlots)), new Object[0]);
        }
        this.originScopeStacks = new ItemStack[this.originScopeSlots.length];
        for (int i = 0; i < this.originScopeSlots.length; ++i) {
            this.originScopeStacks[i] = this.originScopeSlots[i].getItem().copy();
        }
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        Slot slot = otherSlot = originSlot.container == player.getInventory() ? TriggerButtonManager.getContainerRefSlot(op) : TriggerButtonManager.getPlayerRefSlot(op);
        if (otherSlot == null || !op.isDirectional()) {
            this.otherScopeSlots = new Slot[0];
            this.otherScopeStacks = new ItemStack[0];
            return;
        }
        Scope otherScope = this.screenHelper.getScope(otherSlot);
        this.otherScopeSlots = this.collectSlots(otherSlot, otherScope);
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Discovered {} slots in other scope ({} - {}):", this.otherScopeSlots.length, otherScope.ordinal(), otherScope.name());
            dev.terminalmc.clientsort.client.ClientSort.LOG.info(SlotLogUtil.listSlotIds(List.of(this.otherScopeSlots)), new Object[0]);
        }
        this.otherScopeStacks = new ItemStack[this.otherScopeSlots.length];
        for (int i = 0; i < this.otherScopeSlots.length; ++i) {
            this.otherScopeStacks[i] = this.otherScopeSlots[i].getItem().copy();
        }
    }

    private Slot[] collectSlots(Slot refSlot, Scope scope) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (scope == Scope.INVALID) {
            return new Slot[0];
        }
        ItemStack testItem = Items.LIGHT.getDefaultInstance();
        ArrayList<Slot> collectedSlots = new ArrayList<Slot>();
        for (Slot slot : this.screenHelper.getGroupForSlot(refSlot, scope)) {
            ClassPolicy policy;
            Object object;
            int slotId = ((ISlot)slot).clientsort$getIndexInMenu();
            int slotIdx = ((ISlot)slot).clientsort$getIndexInContainer();
            if (!slot.hasItem() ? !slot.container.canPlaceItem(slotId, testItem) || !slot.mayPlace(testItem) : player != null && !slot.mayPickup((Player)player)) continue;
            if (ItemLocksWrapper.isLocked(slot) || (object = ClientSort.getObj(slot, this.screen.getMenu())) == null || (policy = PolicyManager.getPolicy(object.getClass())) != null && policy.ignoredSlots().contains(slotIdx)) continue;
            collectedSlots.add(slot);
        }
        return collectedSlots.toArray(new Slot[0]);
    }

    private boolean canOperate() {
        if (this.hasOperated) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.warn("{} can only be used once!", this.getClass().getSimpleName());
            return false;
        }
        this.hasOperated = true;
        return true;
    }

    public static boolean sort(AbstractContainerScreen<?> screen, Slot originSlot, boolean onlyClient, SortOrder sortOrder) {
        if (sortOrder.equals(SortOrder.NONE)) {
            return false;
        }
        @Nullable SingleUseOperator op = SingleUseOperator.getOperator(screen, originSlot, onlyClient, Operation.SORT);
        if (op != null && op.canOperate()) {
            op.sort(sortOrder);
            return true;
        }
        return false;
    }

    public static boolean fillStacks(AbstractContainerScreen<?> screen, Slot originSlot, boolean onlyClient) {
        @Nullable SingleUseOperator op = SingleUseOperator.getOperator(screen, originSlot, onlyClient, Operation.STACK_FILL);
        if (op != null && op.canOperate()) {
            op.fillStacks();
            return true;
        }
        return false;
    }

    public static boolean transferMatching(AbstractContainerScreen<?> screen, Slot originSlot, boolean onlyClient) {
        @Nullable SingleUseOperator op = SingleUseOperator.getOperator(screen, originSlot, onlyClient, Operation.MATCH_TRANSFER);
        if (op != null && op.canOperate()) {
            op.matchTransfer();
            return true;
        }
        return false;
    }

    public static boolean transfer(AbstractContainerScreen<?> screen, Slot originSlot, boolean onlyClient) {
        @Nullable SingleUseOperator op = SingleUseOperator.getOperator(screen, originSlot, onlyClient, Operation.TRANSFER);
        if (op != null && op.canOperate()) {
            op.transfer();
            return true;
        }
        return false;
    }

    @Nullable
    private static SingleUseOperator getOperator(AbstractContainerScreen<?> screen, Slot originSlot, boolean onlyClient, Operation operation) {
        block15: {
            Object object = ClientSort.getObj(originSlot, screen.getMenu());
            if (object == null) {
                return null;
            }
            @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
            if (policy == null) break block15;
            switch (operation) {
                default: {
                    throw new MatchException(null, null);
                }
                case SORT: {
                    if (!policy.canSort()) break;
                    break block15;
                }
                case STACK_FILL: {
                    if (!policy.canStackFill()) break;
                    break block15;
                }
                case MATCH_TRANSFER: {
                    if (!policy.canMatchTransfer()) break;
                    break block15;
                }
                case TRANSFER: {
                    if (policy.canTransfer()) break block15;
                }
            }
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Operation {} is disallowed by policy for class {}!", operation.name(), policy.getClass());
            }
            return null;
        }
        if (!onlyClient && Config.options().useServerAcceleration && ClientServices.PLATFORM.canSendToServer(operation.type)) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.info("Preparing server operator for {}", operation.name());
            }
            return new ServerOperator(screen, originSlot, operation);
        }
        if (dev.terminalmc.clientsort.client.ClientSort.operatingClient) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Client operation is unavailable: another operation is in progress!", new Object[0]);
            }
            return null;
        }
        if (Minecraft.getInstance().player.isCreative() && screen instanceof CreativeModeInventoryScreen) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.info("Preparing client-creative operator for {}", operation.name());
            }
            return new ClientCreativeOperator(screen, originSlot, operation);
        }
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Preparing client-survival operator for {}", operation.name());
        }
        return new ClientSurvivalOperator(screen, originSlot, operation);
    }

    protected abstract void sort(SortOrder var1);

    protected abstract void fillStacks();

    protected abstract void matchTransfer();

    protected abstract void transfer();

    protected static Slot[] collectMatchingSlots(Slot[] originSlots, ItemStack[] otherStacks, boolean alwaysMatchByType, Set<Item> typeMatchItems) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (Slot slot : originSlots) {
            if (!SingleUseOperator.containsMatchingStack(otherStacks, slot.getItem(), alwaysMatchByType, typeMatchItems)) continue;
            slots.add(slot);
        }
        return slots.toArray(new Slot[0]);
    }

    protected static boolean containsMatchingStack(ItemStack[] stacks, ItemStack stack, boolean alwaysMatchByType, Set<Item> typeMatchItems) {
        for (ItemStack s : stacks) {
            if (!SingleUseOperator.stacksMatch(s, stack, alwaysMatchByType, typeMatchItems)) continue;
            return true;
        }
        return false;
    }

    protected static boolean stacksMatch(ItemStack a, ItemStack b, boolean alwaysMatchByType, Set<Item> typeMatchItems) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b) || ItemStack.isSameItem((ItemStack)a, (ItemStack)b) && (alwaysMatchByType || typeMatchItems.contains(a.getItem()));
    }
}

