/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.client;

import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.interaction.InteractionManager;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.SingleUseOperator;
import dev.terminalmc.clientsort.client.order.SortContext;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.util.SoundManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;

public abstract class ClientOperator
extends SingleUseOperator {
    public ClientOperator(AbstractContainerScreen<?> screen, Slot originSlot, Operation op) {
        super(screen, originSlot, op);
    }

    protected void raiseFlag() {
        ClientSort.operatingClient = true;
    }

    protected void lowerFlag() {
        InteractionManager.push(() -> {
            ClientSort.operatingClient = false;
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void sort(SortOrder sortOrder) {
        if (sortOrder.equals(SortOrder.NONE)) {
            return;
        }
        this.raiseFlag();
        this.collect();
        int[] key = new int[this.originScopeSlots.length];
        for (int i = 0; i < key.length; ++i) {
            key[i] = i;
        }
        key = sortOrder.sort(key, this.originScopeStacks, new SortContext((Level)Minecraft.getInstance().level));
        boolean playSound = SoundManager.shouldPlaySortingSounds();
        if (playSound) {
            SoundManager.resetForCount(SoundManager.estimateSortSounds(this.originScopeStacks));
        }
        this.sort(key, playSound);
        this.lowerFlag();
    }

    protected abstract void collect();

    protected abstract void sort(int[] var1, boolean var2);
}

