/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.server;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.SingleUseOperator;
import dev.terminalmc.clientsort.client.network.handler.CollectResultHandler;
import dev.terminalmc.clientsort.client.network.handler.SortResultHandler;
import dev.terminalmc.clientsort.client.network.handler.StackFillResultHandler;
import dev.terminalmc.clientsort.client.network.handler.TransferResultHandler;
import dev.terminalmc.clientsort.client.order.SortContext;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.platform.ClientServices;
import dev.terminalmc.clientsort.network.payload.CollectPayload;
import dev.terminalmc.clientsort.network.payload.SortPayload;
import dev.terminalmc.clientsort.network.payload.StackFillPayload;
import dev.terminalmc.clientsort.network.payload.TransferPayload;
import dev.terminalmc.clientsort.util.Localization;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ServerOperator
extends SingleUseOperator {
    public ServerOperator(AbstractContainerScreen<?> screen, Slot originSlot, Operation op) {
        super(screen, originSlot, op);
    }

    @Override
    protected void sort(SortOrder sortOrder) {
        if (sortOrder.equals(SortOrder.NONE)) {
            return;
        }
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation SORT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        CollectResultHandler.onCompletion = collectResult -> {
            if (collectResult.isSuccess()) {
                SortResultHandler.onCompletion = sortResult -> {
                    if (!sortResult.isSuccess()) {
                        if (sortResult.isUnknown() || !Config.options().useClientFallback) {
                            this.setOverlayMessage((Component)Component.translatable((String)sortResult.translationKey));
                        } else {
                            SingleUseOperator.sort(this.screen, this.originSlot, true, sortOrder);
                        }
                    }
                };
                ServerOperator sorter = new ServerOperator(this.screen, this.originSlot, this.op);
                int[] slotMapping = sorter.createSlotMapping(sortOrder);
                if (ClientSort.debug()) {
                    dev.terminalmc.clientsort.client.ClientSort.LOG.info("Sending payload for operation SORT", new Object[0]);
                }
                ClientServices.PLATFORM.sendToServer(new SortPayload(this.screen.getMenu().containerId, slotMapping));
            } else if (collectResult.isUnknown() || !Config.options().useClientFallback) {
                this.setOverlayMessage((Component)Component.translatable((String)collectResult.translationKey));
            } else {
                SingleUseOperator.sort(this.screen, this.originSlot, true, sortOrder);
            }
        };
        int[] scopeArray = this.createSlotIdArray(this.originScopeSlots);
        this.sendCollectPayload(scopeArray);
    }

    @Override
    protected void fillStacks() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation STACK_FILL: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation STACK_FILL: other scope is empty!", new Object[0]);
            }
            return;
        }
        StackFillResultHandler.onCompletion = result -> {
            if (!result.isSuccess()) {
                if (result.isUnknown() || !Config.options().useClientFallback) {
                    this.setOverlayMessage((Component)Component.translatable((String)result.translationKey));
                } else {
                    SingleUseOperator.fillStacks(this.screen, this.originSlot, true);
                }
            }
        };
        int[] srcSlotIds = this.createSlotIdArray(this.originScopeSlots);
        int[] dstSlotIds = this.createSlotIdArray(this.otherScopeSlots);
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Sending payload for operation STACK_FILL", new Object[0]);
        }
        ClientServices.PLATFORM.sendToServer(new StackFillPayload(this.screen.getMenu().containerId, srcSlotIds, dstSlotIds));
    }

    @Override
    protected void matchTransfer() {
        this.transfer(ServerOperator.collectMatchingSlots(this.originScopeSlots, this.otherScopeStacks, Config.options().alwaysMatchByType, Config.options().typeMatchItemCache));
    }

    @Override
    protected void transfer() {
        this.transfer(null);
    }

    private void transfer(@Nullable Slot[] overrideSlots) {
        Slot[] originSlots;
        Slot[] slotArray = originSlots = overrideSlots != null ? overrideSlots : this.originScopeSlots;
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation TRANSFER: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (originSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation TRANSFER: origin slots is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation TRANSFER: other scope is empty!", new Object[0]);
            }
            return;
        }
        TransferResultHandler.onCompletion = result -> {
            if (!result.isSuccess()) {
                if (result.isUnknown() || !Config.options().useClientFallback) {
                    this.setOverlayMessage((Component)Component.translatable((String)result.translationKey));
                } else if (overrideSlots != null) {
                    SingleUseOperator.transferMatching(this.screen, this.originSlot, true);
                } else {
                    SingleUseOperator.transfer(this.screen, this.originSlot, true);
                }
            }
        };
        int[] srcSlotIds = this.createSlotIdArray(originSlots);
        int[] dstSlotIds = this.createSlotIdArray(this.otherScopeSlots);
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Sending payload for operation TRANSFER", new Object[0]);
        }
        ClientServices.PLATFORM.sendToServer(new TransferPayload(this.screen.getMenu().containerId, srcSlotIds, dstSlotIds));
    }

    private int[] createSlotIdArray(Slot[] slots) {
        int[] slotIds = new int[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            slotIds[i] = ((ISlot)slots[i]).clientsort$getIndexInMenu();
        }
        this.screenHelper.translateSlotIds(slotIds);
        return slotIds;
    }

    private void sendCollectPayload(int[] scopeArray) {
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Sending payload for operation COLLECT", new Object[0]);
        }
        ClientServices.PLATFORM.sendToServer(new CollectPayload(this.screen.getMenu().containerId, scopeArray));
    }

    private int[] createSlotMapping(SortOrder sortOrder) {
        int[] sortedIds = new int[this.originScopeStacks.length];
        for (int i = 0; i < sortedIds.length; ++i) {
            sortedIds[i] = i;
        }
        sortedIds = sortOrder.sort(sortedIds, this.originScopeStacks, new SortContext((Level)Minecraft.getInstance().level));
        int[] slotMapping = new int[sortedIds.length * 2];
        for (int i = 0; i < sortedIds.length; ++i) {
            Slot from = this.originScopeSlots[sortedIds[i]];
            Slot to = this.originScopeSlots[i];
            slotMapping[i * 2] = ((ISlot)from).clientsort$getIndexInMenu();
            slotMapping[i * 2 + 1] = ((ISlot)to).clientsort$getIndexInMenu();
        }
        this.screenHelper.translateSlotIds(slotMapping);
        return slotMapping;
    }

    private void setOverlayMessage(Component message) {
        dev.terminalmc.clientsort.client.ClientSort.setOverlayMessage(this.screen, (Component)Localization.localized("name", new Object[0]).withStyle(ChatFormatting.RED).append("\n").append(message).append("\n").append((Component)Localization.localized("message", "checkLogs", new Object[0])), 100);
    }
}

