/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.compat.itemlocks;

import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.compat.itemlocks.ItemLocksCompat;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.world.inventory.Slot;

public class ItemLocksWrapper {
    private static boolean hasFailed = false;

    public static boolean isLocked(Slot slot) {
        if (hasFailed) {
            return false;
        }
        try {
            return ItemLocksCompat.isLocked(slot);
        }
        catch (NoClassDefFoundError | NoSuchMethodError ignored) {
            hasFailed = true;
            ClientSort.LOG.info("ItemLocks not found: compat is now disabled", new Object[0]);
            return false;
        }
        catch (Exception e) {
            hasFailed = true;
            ClientSort.LOG.error("ItemLocks threw an unexpected error when checking slot {}: compat is now disabled", ((ISlot)slot).clientsort$getIndexInMenu());
            ClientSort.LOG.error(e.getLocalizedMessage(), new Object[0]);
            return false;
        }
    }
}

