/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.client;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.interaction.InteractionManager;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientOperator;
import dev.terminalmc.clientsort.client.util.SoundManager;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.ArrayDeque;
import java.util.BitSet;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_465;

public class ClientSurvivalOperator
extends ClientOperator {
    public ClientSurvivalOperator(class_465<?> screen, class_1735 originSlot, Operation op) {
        super(screen, originSlot, op);
    }

    @Override
    protected void collect() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation COLLECT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation COLLECT", new Object[0]);
        }
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            class_1735 srcSlot = this.originScopeSlots[i];
            class_1799 srcStack = this.originScopeStacks[i];
            if (srcStack.method_7960() || srcStack.method_7947() >= srcSlot.method_7676(srcStack)) continue;
            clickEvents.add(this.createClickEvent(srcSlot, 0, false));
            for (int j = 0; j < i; ++j) {
                class_1735 dstSlot = this.originScopeSlots[j];
                class_1799 dstStack = this.originScopeStacks[j];
                if (dstStack.method_7960() || dstStack.method_7947() >= dstSlot.method_7676(dstStack) || !class_1799.method_31577((class_1799)srcStack, (class_1799)dstStack)) continue;
                int delta = dstSlot.method_7676(dstStack) - dstStack.method_7947();
                delta = Math.min(delta, srcStack.method_7947());
                srcStack.method_7934(delta);
                dstStack.method_7933(delta);
                clickEvents.add(this.createClickEvent(dstSlot, 0, false));
                if (srcStack.method_7947() <= 0) break;
            }
            if (clickEvents.size() > 1) {
                InteractionManager.pushAll(clickEvents);
                InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
                clickEvents.clear();
                if (srcStack.method_7947() > 0) {
                    InteractionManager.push(this.createClickEvent(srcSlot, 0, false));
                } else {
                    this.originScopeStacks[i] = class_1799.field_8037;
                }
            }
            clickEvents.clear();
        }
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation COLLECT", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @Override
    protected void sort(int[] sortedIds, boolean playSound) {
        int i;
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation SORT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation SORT", new Object[0]);
        }
        int slotCount = this.originScopeStacks.length;
        int[] srcToDst = new int[slotCount];
        for (int i2 = 0; i2 < slotCount; ++i2) {
            srcToDst[sortedIds[i2]] = i2;
        }
        BitSet done = new BitSet(slotCount);
        BitSet empty = new BitSet(slotCount);
        for (i = 0; i < slotCount; ++i) {
            if (i == sortedIds[i]) {
                done.set(i);
            }
            if (!this.originScopeStacks[i].method_7960()) continue;
            empty.set(i);
        }
        block2: for (i = 0; i < slotCount; ++i) {
            if (done.get(i)) continue;
            if (empty.get(sortedIds[i])) {
                done.set(sortedIds[i]);
                continue;
            }
            InteractionManager.push(this.createClickEvent(this.originScopeSlots[sortedIds[i]], 0, playSound));
            class_1799 carriedStack = this.originScopeStacks[sortedIds[i]];
            this.originScopeStacks[sortedIds[i]] = class_1799.field_8037;
            empty.set(sortedIds[i]);
            class_1735 workingSlot = this.originScopeSlots[sortedIds[i]];
            int dstId = i;
            do {
                boolean clickOnItemWithBundle;
                if (!empty.get(dstId) && class_1799.method_31577((class_1799)carriedStack, (class_1799)this.originScopeStacks[dstId])) {
                    if (carriedStack.method_7947() == this.originScopeStacks[dstId].method_7947()) {
                        done.set(dstId);
                        dstId = srcToDst[dstId];
                        continue;
                    }
                    if (carriedStack.method_7947() < this.originScopeStacks[dstId].method_7947()) {
                        class_1735 dstSlot = this.originScopeSlots[dstId];
                        InteractionManager.push(this.createClickEvent(workingSlot, 0, playSound));
                        InteractionManager.push(this.createClickEvent(dstSlot, 0, playSound));
                        InteractionManager.push(this.createClickEvent(workingSlot, 0, playSound));
                        InteractionManager.push(this.createClickEvent(dstSlot, 0, playSound));
                        InteractionManager.push(this.createClickEvent(workingSlot, 0, playSound));
                        class_1799 tmp = carriedStack;
                        carriedStack = this.originScopeStacks[dstId];
                        this.originScopeStacks[dstId] = tmp;
                        done.set(dstId);
                        dstId = srcToDst[dstId];
                        continue;
                    }
                }
                int mouseButton = 0;
                boolean clickOnBundleWithItem = this.originScopeStacks[dstId].method_31574(class_1802.field_27023) && !carriedStack.method_7960();
                boolean bl = clickOnItemWithBundle = carriedStack.method_31574(class_1802.field_27023) && !this.originScopeStacks[dstId].method_7960();
                if (Config.options().bundlesUseLeftClick && (clickOnBundleWithItem || clickOnItemWithBundle)) {
                    mouseButton = 1;
                }
                InteractionManager.push(this.createClickEvent(this.originScopeSlots[dstId], mouseButton, playSound));
                class_1799 tmp = carriedStack;
                carriedStack = this.originScopeStacks[dstId];
                this.originScopeStacks[dstId] = tmp;
                done.set(dstId);
                if (empty.get(dstId)) continue block2;
                dstId = srcToDst[dstId];
            } while (!done.get(dstId));
        }
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation SORT", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @Override
    protected void fillStacks() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation STACK_FILL: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation STACK_FILL: other scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation STACK_FILL", new Object[0]);
        }
        this.raiseFlag();
        boolean playSound = SoundManager.shouldPlayOtherSounds();
        if (playSound) {
            SoundManager.resetForCount(SoundManager.estimateStackFillSounds(this.originScopeStacks, this.otherScopeStacks));
        }
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            class_1735 srcSlot = this.originScopeSlots[i];
            class_1799 srcStack = this.originScopeStacks[i];
            if (srcStack.method_7960()) continue;
            clickEvents.add(this.createClickEvent(srcSlot, 0, false));
            for (int j = 0; j < this.otherScopeSlots.length; ++j) {
                class_1735 dstSlot = this.otherScopeSlots[j];
                class_1799 dstStack = this.otherScopeStacks[j];
                if (dstStack.method_7960() || dstStack.method_7947() >= dstSlot.method_7676(dstStack) || !class_1799.method_31577((class_1799)srcStack, (class_1799)dstStack)) continue;
                int delta = dstSlot.method_7676(dstStack) - dstStack.method_7947();
                delta = Math.min(delta, srcStack.method_7947());
                srcStack.method_7939(srcStack.method_7947() - delta);
                dstStack.method_7939(dstStack.method_7947() + delta);
                clickEvents.add(this.createClickEvent(dstSlot, 0, playSound));
                if (srcStack.method_7947() <= 0) break;
            }
            if (clickEvents.size() > 1) {
                InteractionManager.pushAll(clickEvents);
                InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
                clickEvents.clear();
                if (srcStack.method_7947() > 0) {
                    InteractionManager.push(this.createClickEvent(srcSlot, 0, false));
                } else {
                    this.originScopeStacks[i] = class_1799.field_8037;
                }
            }
            clickEvents.clear();
        }
        this.lowerFlag();
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation STACK_FILL", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @Override
    protected void matchTransfer() {
        this.transfer(ClientSurvivalOperator.collectMatchingSlots(this.originScopeSlots, this.otherScopeStacks, Config.options().alwaysMatchByType, Config.options().typeMatchItemCache));
    }

    @Override
    protected void transfer() {
        this.transfer(this.originScopeSlots);
    }

    protected void transfer(class_1735[] originSlots) {
        boolean playSound;
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation (MATCH_)TRANSFER: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (originSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation (MATCH_)TRANSFER: origin slots is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation (MATCH_)TRANSFER: other scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation (MATCH_)TRANSFER", new Object[0]);
        }
        this.raiseFlag();
        class_1799[] originStacks = this.originScopeStacks;
        if (originSlots != this.originScopeSlots) {
            originStacks = new class_1799[originSlots.length];
            for (int i = 0; i < originSlots.length; ++i) {
                originStacks[i] = originSlots[i].method_7677().method_7972();
            }
        }
        if (playSound = SoundManager.shouldPlayOtherSounds()) {
            SoundManager.resetForCount(SoundManager.estimateTransferSounds(originStacks, this.otherScopeStacks));
        }
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = originSlots.length - 1; i >= 0; --i) {
            class_1735 srcSlot = originSlots[i];
            class_1799 srcStack = originStacks[i];
            if (srcStack.method_7960()) continue;
            clickEvents.add(this.createClickEvent(srcSlot, 0, false));
            int emptySlotId = -1;
            for (int j = 0; j < this.otherScopeSlots.length; ++j) {
                class_1735 dstSlot = this.otherScopeSlots[j];
                class_1799 dstStack = this.otherScopeStacks[j];
                if (dstStack.method_7960()) {
                    if (emptySlotId != -1) continue;
                    emptySlotId = j;
                    continue;
                }
                if (dstStack.method_7947() >= dstSlot.method_7676(dstStack) || !class_1799.method_31577((class_1799)srcStack, (class_1799)dstStack)) continue;
                int delta = dstSlot.method_7676(dstStack) - dstStack.method_7947();
                delta = Math.min(delta, srcStack.method_7947());
                srcStack.method_7939(srcStack.method_7947() - delta);
                dstStack.method_7939(dstStack.method_7947() + delta);
                clickEvents.add(this.createClickEvent(dstSlot, 0, playSound));
                if (srcStack.method_7960()) break;
            }
            if (!srcStack.method_7960() && emptySlotId != -1) {
                class_1735 dstSlot = this.otherScopeSlots[emptySlotId];
                this.otherScopeStacks[emptySlotId] = srcStack.method_7972();
                srcStack.method_7939(0);
                clickEvents.add(this.createClickEvent(dstSlot, 0, playSound));
            }
            if (clickEvents.size() > 1) {
                InteractionManager.pushAll(clickEvents);
                InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
                clickEvents.clear();
                if (srcStack.method_7947() > 0) {
                    InteractionManager.push(this.createClickEvent(srcSlot, 0, false));
                } else {
                    originStacks[i] = class_1799.field_8037;
                }
            }
            clickEvents.clear();
        }
        this.lowerFlag();
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation (MATCH_)TRANSFER", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    private InteractionManager.InteractionEvent createClickEvent(class_1735 slot, int button, boolean playSound) {
        return new InteractionManager.CallbackEvent(() -> {
            ((AbstractContainerScreenAccessor)this.screen).clientsort$slotClicked(slot, ((ISlot)slot).clientsort$getIndexInMenu(), button, class_1713.field_7790);
            if (playSound) {
                SoundManager.play();
            }
            return InteractionManager.TICK_WAITER;
        });
    }
}

