/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.order;

import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.order.StackMatcher;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;

public class CreativeSearchOrder {
    private static final Object2IntMap<StackMatcher> stackPositionMap = new Object2IntOpenHashMap();
    private static final ReadWriteLock stackPositionMapLock;

    public static Lock getReadLock() {
        return stackPositionMapLock.readLock();
    }

    public static int getPosition(class_1799 stack) {
        int pos = stackPositionMap.getInt((Object)StackMatcher.of(stack));
        if (pos == Integer.MAX_VALUE) {
            pos = stackPositionMap.getInt((Object)StackMatcher.ignoreNbt(stack));
        }
        return pos;
    }

    public static void tryRefreshStackPositionMap() {
        if (Config.options().optimizeCreativeSorting) {
            if (ClientSort.emiReloading) {
                ClientSort.updateBlockedByEmi = true;
                ClientSort.LOG.info("Search order update blocked by EMI reload, waiting...", new Object[0]);
            } else {
                CreativeSearchOrder.refreshStackPositionMap();
            }
        } else {
            Lock lock = stackPositionMapLock.writeLock();
            lock.lock();
            stackPositionMap.clear();
            lock.unlock();
        }
    }

    private static void refreshStackPositionMap() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        class_7699 enabledFeatures = mc.field_1687.method_45162();
        boolean opTab = mc.field_1724.method_7338() && (Boolean)mc.field_1690.method_47395().method_41753() != false;
        class_7706.method_47330((class_7699)enabledFeatures, (!opTab ? 1 : 0) != 0, (class_7225.class_7874)mc.field_1687.method_30349());
        ArrayList displayStacks = new ArrayList(class_7706.method_47344().method_47313());
        new Thread(() -> {
            Lock lock = stackPositionMapLock.writeLock();
            lock.lock();
            stackPositionMap.clear();
            if (displayStacks.isEmpty()) {
                lock.unlock();
                return;
            }
            int i = 0;
            for (class_1799 stack : displayStacks) {
                StackMatcher plainMatcher = StackMatcher.ignoreNbt(stack);
                if (!stack.method_7958() || !stackPositionMap.containsKey((Object)plainMatcher)) {
                    stackPositionMap.put((Object)plainMatcher, i);
                    ++i;
                }
                stackPositionMap.put((Object)StackMatcher.of(stack), i);
                ++i;
            }
            lock.unlock();
        }, "ClientSort: creative search stack position lookup builder").start();
    }

    static {
        stackPositionMap.defaultReturnValue(Integer.MAX_VALUE);
        stackPositionMapLock = new ReentrantReadWriteLock();
    }
}

