/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.platform.Services;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConfig {
    private static final Path CONFIG_DIR = Services.PLATFORM.getConfigDir();
    public static final String FILE_NAME = "clientsort-server.json";
    private static final String BACKUP_FILE_NAME = "clientsort-server.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public final Options options = new Options();
    private static ServerConfig instance = null;

    public static Options serverOptions() {
        return ServerConfig.get().options;
    }

    private void validate() {
        this.options.classPolicies = Options.classPoliciesValidator.validate(this.options.classPolicies);
    }

    private void upgradeLegacy() {
        if (this.options.validateOperationResults != null) {
            this.options.validateOperationResults = null;
            this.options.classPolicies = Options.classPoliciesDefault.get();
        }
    }

    public static ServerConfig get() {
        if (instance == null) {
            instance = ServerConfig.load();
        }
        return instance;
    }

    public static ServerConfig getAndSave() {
        ServerConfig.get();
        ServerConfig.save();
        return instance;
    }

    public static ServerConfig reloadAndSave() {
        instance = ServerConfig.load();
        ServerConfig.save();
        return instance;
    }

    public static ServerConfig resetAndSave() {
        instance = new ServerConfig();
        ServerConfig.save();
        return instance;
    }

    @NotNull
    public static ServerConfig load() {
        Path file = CONFIG_DIR.resolve(FILE_NAME);
        ServerConfig serverConfig = null;
        if (Files.exists(file, new LinkOption[0])) {
            serverConfig = ServerConfig.load(file, GSON);
            if (serverConfig == null) {
                ServerConfig.backup();
                ClientSort.LOG.warn("Resetting config", new Object[0]);
            } else {
                serverConfig.upgradeLegacy();
            }
        }
        return serverConfig != null ? serverConfig : new ServerConfig();
    }

    @Nullable
    private static ServerConfig load(Path file, Gson gson) {
        ServerConfig serverConfig;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            serverConfig = (ServerConfig)gson.fromJson((Reader)reader, ServerConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ClientSort.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return serverConfig;
    }

    private static void backup() {
        try {
            ClientSort.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ClientSort.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.validate();
        try {
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            ClientSort.onConfigSaved(instance);
        }
        catch (IOException e) {
            ClientSort.LOG.error("Unable to save config", e);
        }
    }

    public static class Options {
        @Nullable
        public Boolean validateOperationResults;
        @Nullable
        public Boolean validationActiveSingleplayer;
        public static final boolean validationActiveServerDefault = true;
        public boolean validationActiveServer = true;
        public static final boolean validateItemTypeDefault = true;
        public boolean validateItemType = true;
        public static final boolean validateStackSizeDefault = true;
        public boolean validateStackSize = true;
        public static final int validateStackSizeThresholdDefault = 32;
        public int validateStackSizeThreshold = 32;
        public static final boolean alwaysLogUnexpectedResultsDefault = true;
        public boolean alwaysLogUnexpectedResults = true;
        public static final Supplier<List<ServerClassPolicy>> classPoliciesDefaultList = () -> List.of(new ServerClassPolicy("com.simibubi.create.content.equipment.toolbox.ToolboxMenu", false, false, false), new ServerClassPolicy("com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu", false, false, false), new ServerClassPolicy("com.tom.storagemod.menu.CraftingTerminalMenu", false, false, false), new ServerClassPolicy("com.tom.storagemod.menu.StorageTerminalMenu", false, false, false));
        public static final Supplier<Map<String, ServerClassPolicy>> classPoliciesDefault = () -> {
            LinkedHashMap map = new LinkedHashMap();
            classPoliciesDefaultList.get().forEach(item -> map.put(item.className, item));
            return map;
        };
        public Map<String, ServerClassPolicy> classPolicies = classPoliciesDefault.get();
        public static Validator<Map<String, ServerClassPolicy>> classPoliciesValidator = val -> {
            LinkedHashMap validPolicies = new LinkedHashMap();
            if (val == null) {
                return validPolicies;
            }
            val.values().forEach(cp -> {
                if (cp != null && cp.className != null && !cp.className.isBlank()) {
                    validPolicies.put(cp.className, new ServerClassPolicy(cp.className, cp.sortEnabled, cp.stackFillEnabled, cp.transferEnabled, cp.lastAutoEditTime, cp.lastAutoEditReason));
                }
            });
            LinkedHashMap sortedPolicies = new LinkedHashMap();
            validPolicies.keySet().stream().sorted().forEach(k -> sortedPolicies.put(k, (ServerClassPolicy)validPolicies.get(k)));
            return sortedPolicies;
        };
    }

    @FunctionalInterface
    public static interface Validator<T> {
        @NotNull
        public T validate(@Nullable T var1);
    }
}

