/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.order;

import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.order.StackMatcher;
import dev.terminalmc.clientsort.mixin.client.accessor.CreativeModeTabsAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;

public class CreativeSearchOrder {
    private static final Object2IntMap<StackMatcher> stackPositionMap = new Object2IntOpenHashMap();
    private static final ReadWriteLock stackPositionMapLock;

    public static Lock getReadLock() {
        return stackPositionMapLock.readLock();
    }

    public static int getPosition(class_1799 stack) {
        int pos = stackPositionMap.getInt((Object)StackMatcher.of(stack));
        if (pos == Integer.MAX_VALUE) {
            pos = stackPositionMap.getInt((Object)StackMatcher.ignoreNbt(stack));
        }
        return pos;
    }

    public static void tryRefreshStackPositionMap() {
        if (Config.options().optimizeCreativeSorting) {
            if (ClientSort.emiReloading) {
                ClientSort.updateBlockedByEmi = true;
                ClientSort.LOG.info("Search order update blocked by EMI reload, waiting...", new Object[0]);
            } else {
                CreativeSearchOrder.refreshStackPositionMap();
            }
        } else {
            Lock lock = stackPositionMapLock.writeLock();
            lock.lock();
            stackPositionMap.clear();
            lock.unlock();
        }
    }

    private static void refreshStackPositionMap() {
        List<class_1799> displayStacks;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        class_7699 enabledFeatures = mc.field_1687.method_45162();
        try {
            class_7706.method_47330((class_7699)enabledFeatures, (boolean)true, (class_7225.class_7874)mc.field_1687.method_30349());
            displayStacks = class_7706.method_47344().method_47313().stream().map(class_1799::method_7972).toList();
        }
        finally {
            CreativeModeTabsAccessor.clientsort$setCachedParameters(null);
        }
        new Thread(() -> {
            Lock lock = stackPositionMapLock.writeLock();
            try {
                lock.lock();
                stackPositionMap.clear();
                int i = 0;
                for (class_1799 stack : displayStacks) {
                    StackMatcher plainMatcher = StackMatcher.ignoreNbt(stack);
                    if (!stack.method_7958() || !stackPositionMap.containsKey((Object)plainMatcher)) {
                        stackPositionMap.put((Object)plainMatcher, i);
                        ++i;
                    }
                    stackPositionMap.put((Object)StackMatcher.of(stack), i);
                    ++i;
                }
            }
            finally {
                lock.unlock();
            }
        }, "ClientSort: creative sort builder").start();
    }

    static {
        stackPositionMap.defaultReturnValue(Integer.MAX_VALUE);
        stackPositionMapLock = new ReentrantReadWriteLock();
    }
}

