/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.screen.edit.ContainerEditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.PlayerEditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.gui.widget.MatchTransferButton;
import dev.terminalmc.clientsort.client.gui.widget.SortButton;
import dev.terminalmc.clientsort.client.gui.widget.StackFillButton;
import dev.terminalmc.clientsort.client.gui.widget.TransferButton;
import dev.terminalmc.clientsort.client.gui.widget.TriggerButton;
import dev.terminalmc.clientsort.client.inventory.Scope;
import dev.terminalmc.clientsort.client.inventory.helper.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.mixin.client.accessor.ScreenAccessor;
import dev.terminalmc.clientsort.util.Localization;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class TriggerButtonManager {
    private static final int BUTTON_SPACING = 1;
    private static final int BUTTON_SHIFT_X = 0;
    private static final int BUTTON_SHIFT_Y = 1;
    @Nullable
    private static class_465<?> screen;
    private static final LinkedHashSet<TriggerButton> containerButtons;
    private static final LinkedHashSet<TriggerButton> visibleContainerButtons;
    private static final LinkedHashSet<TriggerButton> playerButtons;
    private static final LinkedHashSet<TriggerButton> visiblePlayerButtons;

    private TriggerButtonManager() {
    }

    @Nullable
    public static class_465<?> getScreen() {
        return screen;
    }

    public static LinkedList<TriggerButton> getContainerButtons() {
        return new LinkedList<TriggerButton>(containerButtons);
    }

    public static LinkedList<TriggerButton> getPlayerButtons() {
        return new LinkedList<TriggerButton>(playerButtons);
    }

    @Nullable
    public static class_1735 getContainerRefSlot(Operation op) {
        return TriggerButtonManager.getRefSlot(containerButtons, op);
    }

    @Nullable
    public static class_1735 getPlayerRefSlot(Operation op) {
        return TriggerButtonManager.getRefSlot(playerButtons, op);
    }

    @Nullable
    private static class_1735 getRefSlot(LinkedHashSet<TriggerButton> buttons, Operation op) {
        Class clazz = switch (op) {
            default -> throw new MatchException(null, null);
            case Operation.SORT -> SortButton.class;
            case Operation.STACK_FILL -> StackFillButton.class;
            case Operation.MATCH_TRANSFER -> MatchTransferButton.class;
            case Operation.TRANSFER -> TransferButton.class;
        };
        for (TriggerButton button : buttons) {
            if (!((Object)((Object)button)).getClass().equals(clazz)) continue;
            return button.referenceSlot;
        }
        return null;
    }

    public static void afterScreenInit(class_437 initScreen) {
        class_1735 refSlotP;
        if (!(initScreen instanceof class_465)) {
            return;
        }
        class_465 acs = (class_465)initScreen;
        if (screen != null) {
            TriggerButtonManager.getContainerButtons().forEach(b -> ((ScreenAccessor)screen).clientsort$removeWidget((class_364)b));
            TriggerButtonManager.getPlayerButtons().forEach(b -> ((ScreenAccessor)screen).clientsort$removeWidget((class_364)b));
        }
        containerButtons.clear();
        visibleContainerButtons.clear();
        playerButtons.clear();
        visiblePlayerButtons.clear();
        screen = acs;
        boolean enabled = Config.options().showButtons;
        boolean isEditorC = false;
        boolean isEditorP = false;
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof SelectorScreen) {
            isEditorC = true;
            isEditorP = true;
        } else if (currentScreen instanceof ContainerEditorScreen) {
            isEditorC = true;
        } else if (currentScreen instanceof PlayerEditorScreen) {
            isEditorP = true;
        }
        class_1735 refSlotC = TriggerButtonManager.getReferenceSlot(acs, false);
        if (refSlotC != null) {
            TriggerButtonManager.generate(acs, refSlotC, false, isEditorC, enabled, Config.options().firstButtonOp);
            TriggerButtonManager.generate(acs, refSlotC, false, isEditorC, enabled, Config.options().secondButtonOp);
            TriggerButtonManager.generate(acs, refSlotC, false, isEditorC, enabled, Config.options().thirdButtonOp);
            TriggerButtonManager.generate(acs, refSlotC, false, isEditorC, enabled, Config.options().fourthButtonOp);
        }
        if ((refSlotP = TriggerButtonManager.getReferenceSlot(acs, true)) != null) {
            TriggerButtonManager.generate(acs, refSlotP, true, isEditorP, enabled, Config.options().firstButtonOp);
            TriggerButtonManager.generate(acs, refSlotP, true, isEditorP, enabled, Config.options().secondButtonOp);
            TriggerButtonManager.generate(acs, refSlotP, true, isEditorP, enabled, Config.options().thirdButtonOp);
            TriggerButtonManager.generate(acs, refSlotP, true, isEditorP, enabled, Config.options().fourthButtonOp);
        }
    }

    private static void generate(class_465<?> screen, class_1735 refSlot, boolean isPlayerInv, boolean isEditor, boolean enabled, Operation op) {
        switch (op) {
            case SORT: {
                TriggerButtonManager.generateSimpleButton(screen, refSlot, isPlayerInv, isEditor, enabled, ClassPolicy::canSort, ClassPolicy::showSortButton, SortButton::new, (class_2561)Localization.localized("key", "op.sort", new Object[0]));
                break;
            }
            case STACK_FILL: {
                TriggerButtonManager.generateDirectionalButton(screen, refSlot, isPlayerInv, isEditor, enabled, ClassPolicy::canStackFill, ClassPolicy::showStackFillButton, StackFillButton::new, (class_2561)Localization.localized("key", "op.stackFill", new Object[0]));
                break;
            }
            case MATCH_TRANSFER: {
                TriggerButtonManager.generateDirectionalButton(screen, refSlot, isPlayerInv, isEditor, enabled, ClassPolicy::canMatchTransfer, ClassPolicy::showMatchTransferButton, MatchTransferButton::new, (class_2561)Localization.localized("key", "op.matchTransfer", new Object[0]));
                break;
            }
            case TRANSFER: {
                TriggerButtonManager.generateDirectionalButton(screen, refSlot, isPlayerInv, isEditor, enabled, ClassPolicy::canTransfer, ClassPolicy::showTransferButton, TransferButton::new, (class_2561)Localization.localized("key", "op.transfer", new Object[0]));
            }
        }
    }

    private static void generateSimpleButton(class_465<?> screen, class_1735 referenceSlot, boolean isPlayerInv, boolean isEditor, boolean enabled, Function<ClassPolicy, Boolean> opCheck, Function<ClassPolicy, Boolean> buttonCheck, TriggerButtonCreator creator, class_2561 name) {
        boolean add;
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInv) {
            return;
        }
        @Nullable Object container = isPlayerInv ? player.method_31548() : TriggerButtonManager.getContainer((class_1657)player);
        Object object = ClientSort.getObj((class_1263)container, screen.method_17577());
        if (object == null) {
            return;
        }
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
        boolean create = isEditor || policy == null || opCheck.apply(policy) != false;
        boolean bl = add = enabled && (isEditor || policy != null && buttonCheck.apply(policy) != false);
        if (!create) {
            return;
        }
        Vec2i offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        TriggerButton button = creator.create(screen, (class_1263)container, referenceSlot, isPlayerInv, policy, object.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv), name);
        (isPlayerInv ? playerButtons : containerButtons).add(button);
        if (add) {
            (isPlayerInv ? visiblePlayerButtons : visibleContainerButtons).add(button);
            ((ScreenAccessor)screen).clientsort$addRenderableWidget(button);
        }
    }

    private static void generateDirectionalButton(class_465<?> screen, class_1735 referenceSlot, boolean isPlayerInv, boolean isEditor, boolean enabled, Function<ClassPolicy, Boolean> opCheck, Function<ClassPolicy, Boolean> buttonCheck, TriggerButtonCreator creator, class_2561 name) {
        class_1263 dstContainer;
        boolean add;
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInv) {
            return;
        }
        @Nullable Object container = isPlayerInv ? player.method_31548() : TriggerButtonManager.getContainer((class_1657)player);
        Object object = ClientSort.getObj((class_1263)container, screen.method_17577());
        if (object == null) {
            return;
        }
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
        boolean create = isEditor || policy == null || opCheck.apply(policy) != false;
        boolean bl = add = enabled && (isEditor || policy != null && buttonCheck.apply(policy) != false);
        if (!create) {
            return;
        }
        Vec2i offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        Object object2 = dstContainer = isPlayerInv ? TriggerButtonManager.getContainer((class_1657)player) : player.method_31548();
        if (dstContainer != null) {
            Object dstObject = ClientSort.getObj(dstContainer, screen.method_17577());
            if (dstObject == null) {
                return;
            }
            @Nullable ClassPolicy dstPolicy = PolicyManager.getPolicy(dstObject.getClass());
            create = isEditor || dstPolicy == null || opCheck.apply(dstPolicy) != false;
            boolean bl2 = add = add && (isEditor || dstPolicy != null && buttonCheck.apply(dstPolicy) != false);
            if (!create) {
                return;
            }
        }
        TriggerButton button = creator.create(screen, (class_1263)container, referenceSlot, isPlayerInv, policy, object.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv), name);
        (isPlayerInv ? playerButtons : containerButtons).add(button);
        if (add) {
            (isPlayerInv ? visiblePlayerButtons : visibleContainerButtons).add(button);
            ((ScreenAccessor)screen).clientsort$addRenderableWidget(button);
        }
    }

    @Nullable
    public static class_1263 getContainer(class_1657 player) {
        class ScoredContainer {
            public final class_1263 container;
            public int score;

            public ScoredContainer(class_1263 container, int score) {
                this.container = container;
                this.score = score;
            }
        }
        HashMap<class_1263, ScoredContainer> map = new HashMap<class_1263, ScoredContainer>();
        for (class_1735 slot : player.field_7512.field_7761) {
            if (slot.field_7871 == null) continue;
            if (slot.field_7871 == player.method_31548() || slot.field_7871 instanceof class_1661) break;
            @Nullable TriggerButtonManager.1ScoredContainer scoredContainer = (ScoredContainer)map.get(slot.field_7871);
            if (scoredContainer == null) {
                map.put(slot.field_7871, new ScoredContainer(slot.field_7871, 1));
                continue;
            }
            ++scoredContainer.score;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map.values().stream().max(Comparator.comparingInt((ToIntFunction<ScoredContainer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$getContainer$2(dev.terminalmc.clientsort.client.gui.TriggerButtonManager$1ScoredContainer ), (Ldev/terminalmc/clientsort/client/gui/TriggerButtonManager$1ScoredContainer;)I)())).get().container;
    }

    @Nullable
    private static class_1735 getReferenceSlot(class_465<?> screen, boolean isPlayerInv) {
        ContainerScreenHelper<class_465<?>> helper = ContainerScreenHelper.of(screen);
        class_1735 bestSlot = null;
        double bestScore = 0.0;
        Scope scope = isPlayerInv ? Scope.PLAYER_INV : Scope.CONTAINER_INV;
        for (class_1735 slot : helper.getLargestSlotGroup(scope)) {
            double y;
            double x = (double)Math.clamp((long)slot.field_7873, 0, screen.field_22789) / (double)screen.field_22789;
            double score = x * 0.8 + (y = (double)(screen.field_22790 - Math.clamp((long)slot.field_7872, 0, screen.field_22790)) / (double)screen.field_22790) * 0.2;
            if (!(score > bestScore)) continue;
            bestSlot = slot;
            bestScore = score;
        }
        return bestSlot;
    }

    public static Vec2i getShiftedOffset(Vec2i offset, boolean isPlayerInv) {
        int index = (isPlayerInv ? visiblePlayerButtons : visibleContainerButtons).size();
        int x = offset.x() + 0 * index;
        int y = offset.y() + 14 * index;
        return new Vec2i(x, y);
    }

    private static /* synthetic */ int lambda$getContainer$2(1ScoredContainer s) {
        return s.score;
    }

    static {
        containerButtons = new LinkedHashSet();
        visibleContainerButtons = new LinkedHashSet();
        playerButtons = new LinkedHashSet();
        visiblePlayerButtons = new LinkedHashSet();
    }

    @FunctionalInterface
    public static interface TriggerButtonCreator {
        public TriggerButton create(class_465<?> var1, class_1263 var2, class_1735 var3, boolean var4, @Nullable ClassPolicy var5, String var6, Vec2i var7, class_2561 var8);
    }
}

