/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.util;

import dev.terminalmc.clientsort.client.config.Config;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class SoundManager {
    private static long nextSoundTime = Long.MIN_VALUE;
    private static float pitch = 1.0f;
    private static float increment = 0.01f;
    @Nullable
    private static class_1113 sound;

    public static boolean shouldPlaySortingSounds() {
        return Config.options().playSoundSort && Config.options().soundVolume > 0.0f;
    }

    public static boolean shouldPlayOtherSounds() {
        return Config.options().playSoundOther && Config.options().soundVolume > 0.0f;
    }

    public static void resetForCount(int size) {
        increment = (Config.options().soundPitchMax - Config.options().soundPitchMin) / (float)size;
        pitch = Config.options().soundPitchMin;
    }

    public static void play() {
        long now = class_156.method_658();
        float soundPitch = SoundManager.getPitch();
        if (now >= nextSoundTime) {
            nextSoundTime = now + (long)Config.options().soundInterval;
            class_2960 location = Config.options().sortSoundLoc;
            if (location != null) {
                if (sound != null && !Config.options().allowSoundOverlap) {
                    class_310.method_1551().method_1483().method_4870(sound);
                }
                sound = new class_1109(location, class_3419.field_15250, Config.options().soundVolume, soundPitch, class_1113.method_43221(), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true);
                class_310.method_1551().method_1483().method_4873(sound);
            }
        }
    }

    private static float getPitch() {
        float val = pitch;
        if ((pitch += increment) > Config.options().soundPitchMax) {
            pitch = Config.options().soundPitchMax;
        }
        return val;
    }

    public static int estimateSortSounds(class_1799[] stacks) {
        int stackCount = 0;
        for (class_1799 stack : stacks) {
            if (stack == class_1799.field_8037) continue;
            ++stackCount;
        }
        int compaction = 0;
        for (int i = 0; i < stackCount; ++i) {
            if (stacks[i] != class_1799.field_8037) continue;
            ++compaction;
        }
        int size = stackCount + compaction;
        size += size / 15;
        return size;
    }

    public static int estimateStackFillSounds(class_1799[] srcStacks, class_1799[] dstStacks) {
        int dstPartialCount = 0;
        for (class_1799 stack : dstStacks) {
            if (stack == class_1799.field_8037 || stack.method_7947() >= stack.method_7914()) continue;
            ++dstPartialCount;
        }
        int srcStackCount = 0;
        for (class_1799 stack : srcStacks) {
            if (stack == class_1799.field_8037) continue;
            ++srcStackCount;
        }
        return (dstPartialCount / 2 + srcStackCount / 2) / 2;
    }

    public static int estimateTransferSounds(class_1799[] srcStacks, class_1799[] dstStacks) {
        int srcStackCount = 0;
        for (class_1799 stack : srcStacks) {
            if (stack == class_1799.field_8037) continue;
            ++srcStackCount;
        }
        int dstHoleCount = 0;
        for (class_1799 stack : dstStacks) {
            if (stack != class_1799.field_8037) continue;
            ++dstHoleCount;
        }
        dstHoleCount += dstHoleCount / 8;
        return Math.min(srcStackCount, dstHoleCount);
    }
}

