#version 150

vec2 texSize = textureSize(Sampler0,0);
vec4 preColor = texture(Sampler0, texCoord0);

vec3 color(int r, int g, int b) {
	return vec3(r,g,b)/255.;
}

vec4 coordColor(int x, int y) {
	return texture(Sampler0, vec2(x/texSize.x, y/texSize.y));
}

bool coordColorIs(int x, int y, int r, int g, int b) {
	return coordColor(x,y).rgb == color(r,g,b);
}

bool isCape() {
	/*
	// Using code for detecting capes from https://github.com/McTsts/mc-core-shaders
	return ( && texture(Sampler0, vec2(0.0, 1.0/32.0)).a == 1.0 && texture(Sampler0, vec2(12.0/64.0, 16.0/32.0)).a == 1.0 && // check if skin transparent pixels have color
			(	// support both types of cape texture
				(texture(Sampler0, vec2(0.0, 18.0/32.0)) == vec4(1.0) && texture(Sampler0, vec2(0.99, 0.99)) == vec4(1.0) && texture(Sampler0, vec2(0.99, 0.0)) == vec4(1.0)) // for capes filled with white, check for white pixels
				|| (texture(Sampler0, vec2(25.0/64.0, 25.0/32.0)).a == 0.0 || texture(Sampler0, vec2(30.0/64.0, 10.0/32.0)).a == 0.0 || texture(Sampler0, vec2(9.0/64.0, 25.0/32.0)).a == 0.0)  // otherwise check of transparent pixels
			));
			
	*/
	
	return (texSize.x == 64 && texSize.y == 32 && coordColor(0,0).a == 0.0);
}

bool isSteveCape() {
	return (isCape() && coordColorIs(40,7,38,26,22) && coordColorIs(39,8,38,26,22) && coordColorIs(40,9,232, 150, 106));
}

bool isMovieCapePortal() {
	return (isSteveCape() && (((texCoord0.x > 4/64. && texCoord0.x < 8/64.) || (texCoord0.x > 15/64. && texCoord0.x < 19/64.)) && texCoord0.y > 8/32. && texCoord0.y < 14/32.));
}