/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.silentechoresidual.entity;

import net.mcreator.silentechoresidual.init.SilentEchoResidualModEntities;
import net.mcreator.silentechoresidual.init.SilentEchoResidualModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class PoltergeistEntity
extends Monster {
    public final AnimationState animationState0 = new AnimationState();
    private long lastAggroTime = 0L;
    private boolean customAggressive = false;

    public PoltergeistEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<PoltergeistEntity>)((EntityType)SilentEchoResidualModEntities.POLTERGEIST.get()), world);
    }

    public PoltergeistEntity(EntityType<PoltergeistEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AggressionGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }

            public boolean m_8036_() {
                return ((PoltergeistEntity)this.f_25540_).isCustomAggressive() && super.m_8036_();
            }

            public boolean m_8045_() {
                return ((PoltergeistEntity)this.f_25540_).isCustomAggressive() && super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)SilentEchoResidualModItems.MEAT_NUGGET.get()));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268565_) || damagesource.m_276093_(DamageTypes.f_268448_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_) || damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.animationState0.m_246184_(true, this.f_19797_);
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)SilentEchoResidualModEntities.POLTERGEIST.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 25.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        return builder;
    }

    public boolean isCustomAggressive() {
        return this.customAggressive;
    }

    public void setCustomAggressive(boolean value) {
        this.customAggressive = value;
    }

    static class AggressionGoal
    extends Goal {
        private final PoltergeistEntity mob;
        private Player target;
        private long startTime;

        public AggressionGoal(PoltergeistEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            int cooldown;
            long elapsed = this.mob.m_9236_().m_46467_() - this.mob.lastAggroTime;
            if (elapsed < (long)(cooldown = this.mob.m_217043_().m_188503_(400) + 400)) {
                return false;
            }
            this.target = this.mob.m_9236_().m_45930_((Entity)this.mob, 12.0);
            return this.target != null;
        }

        public void m_8056_() {
            this.mob.lastAggroTime = this.startTime = this.mob.m_9236_().m_46467_();
            this.mob.setCustomAggressive(true);
            this.mob.m_6710_((LivingEntity)this.target);
            if (!this.mob.m_9236_().m_5776_()) {
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.growl")), SoundSource.HOSTILE, 1.0f, 1.0f);
                Level level = this.mob.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.mob.m_20185_(), this.mob.m_20186_() + (double)this.mob.m_20206_() * 0.5, this.mob.m_20189_(), 10, 0.5, 0.5, 0.5, 0.01);
                }
            }
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            this.mob.m_21573_().m_5624_((Entity)this.target, 1.2);
            if (this.mob.m_9236_().m_46467_() - this.startTime > 100L) {
                this.m_8041_();
            }
        }

        public boolean m_8045_() {
            return this.target != null && this.mob.m_9236_().m_46467_() - this.startTime <= 100L;
        }

        public void m_8041_() {
            this.target = null;
            this.mob.m_21573_().m_26573_();
            this.mob.setCustomAggressive(false);
            this.mob.m_6710_(null);
        }
    }
}

