/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepiglins.blocks;

import com.shiftthedev.alexandria.Alexandria;
import com.shiftthedev.alexandria.blocks.ContainerBlockEntity;
import com.shiftthedev.alexandria.blocks.EntityContainer;
import com.shiftthedev.alexandria.data.EntityDataComponent;
import com.shiftthedev.alexandria.network.RequestUpdatePacket;
import com.shiftthedev.pickablepiglins.PPRegistry;
import com.shiftthedev.pickablepiglins.PickablePiglins;
import com.shiftthedev.pickablepiglins.containers.BarterContainer;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_4836;
import net.minecraft.class_52;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class BarterBlockEntity
extends ContainerBlockEntity
implements EntityContainer<class_4836> {
    private int piglinCount = 0;
    private class_4836 piglinA = null;
    private class_1799 piglinStackA = class_1799.field_8037;
    private class_4836 piglinB = null;
    private class_1799 piglinStackB = class_1799.field_8037;
    private class_4836 piglinC = null;
    private class_1799 piglinStackC = class_1799.field_8037;
    private class_4836 piglinD = null;
    private class_1799 piglinStackD = class_1799.field_8037;
    private static final String piglinKeyA = "piglin_stack_a";
    private static final String piglinKeyB = "piglin_stack_b";
    private static final String piglinKeyC = "piglin_stack_c";
    private static final String piglinKeyD = "piglin_stack_d";
    private int barteringProgress;

    public BarterBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)PPRegistry.BARTER_BLOCKENTITY.get(), blockPos, blockState);
        this.items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        this.validInputs = class_2371.method_10213((int)1, (Object)class_1802.field_8695);
        this.SLOTS_FOR_UP = new int[]{0};
        this.SLOTS_FOR_DOWN = new int[]{1, 2, 3, 4};
        this.displayName = class_2561.method_43471((String)"block.pickablepiglins.piglin_barter");
        this.resetIfNeed();
    }

    protected boolean isValidInput(int slotIndex, class_1799 itemStack) {
        return slotIndex == 0 && itemStack.method_7909() == class_1802.field_8695;
    }

    public boolean isValidEntity(class_1309 livingEntity) {
        return livingEntity instanceof class_4836;
    }

    public int getEntityCount() {
        return this.piglinCount;
    }

    public class_1269 addEntity(class_4836 piglin, class_1799 stack, class_3222 serverPlayer, class_3218 serverLevel) {
        if (this.hasMaxPiglins() || this.foundPiglin(piglin.method_5667())) {
            return class_1269.field_5814;
        }
        piglin.method_5814((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5);
        switch (this.piglinCount) {
            case 0: {
                this.piglinA = piglin;
                this.piglinStackA = stack;
                break;
            }
            case 1: {
                this.piglinB = piglin;
                this.piglinStackB = stack;
                break;
            }
            case 2: {
                this.piglinC = piglin;
                this.piglinStackC = stack;
                break;
            }
            case 3: {
                this.piglinD = piglin;
                this.piglinStackD = stack;
            }
        }
        this.piglinCount = Math.min(this.piglinCount + 1, 4);
        this.resetIfNeed();
        serverPlayer.method_31548().method_7378(stack);
        this.markUpdated();
        this.field_11863.method_16107().method_15407();
        return class_1269.field_5812;
    }

    public class_1799 removeEntity() {
        if (this.field_11863 == null) {
            return class_1799.field_8037;
        }
        class_1799 toRemove = class_1799.field_8037;
        switch (this.piglinCount) {
            case 1: {
                toRemove = this.piglinStackA.method_7972();
                this.piglinStackA = class_1799.field_8037;
                this.piglinA = null;
                break;
            }
            case 2: {
                toRemove = this.piglinStackB.method_7972();
                this.piglinStackB = class_1799.field_8037;
                this.piglinB = null;
                break;
            }
            case 3: {
                toRemove = this.piglinStackC.method_7972();
                this.piglinStackC = class_1799.field_8037;
                this.piglinC = null;
                break;
            }
            case 4: {
                toRemove = this.piglinStackD.method_7972();
                this.piglinStackD = class_1799.field_8037;
                this.piglinD = null;
            }
        }
        this.piglinCount = Math.max(0, this.piglinCount - 1);
        this.resetIfNeed();
        this.markUpdated();
        this.field_11863.method_16107().method_15407();
        return toRemove;
    }

    public void dropEntities(class_1937 level, class_2338 blockPos) {
        if (!this.piglinStackA.method_7960()) {
            class_1264.method_5449((class_1937)level, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_1799)this.piglinStackA);
        }
        if (!this.piglinStackB.method_7960()) {
            class_1264.method_5449((class_1937)level, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_1799)this.piglinStackB);
        }
        if (!this.piglinStackC.method_7960()) {
            class_1264.method_5449((class_1937)level, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_1799)this.piglinStackC);
        }
        if (!this.piglinStackD.method_7960()) {
            class_1264.method_5449((class_1937)level, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_1799)this.piglinStackD);
        }
    }

    public static <A extends class_2586> void doBartering(class_1937 level, class_2338 blockPos, class_2680 blockState, A blockEntity) {
        if (!(blockEntity instanceof BarterBlockEntity)) {
            return;
        }
        BarterBlockEntity barterBlockEntity = (BarterBlockEntity)blockEntity;
        if (barterBlockEntity.hasNoPiglins() || barterBlockEntity.isInputEmpty() || barterBlockEntity.isOutputFull()) {
            return;
        }
        if (barterBlockEntity.isBartering()) {
            --barterBlockEntity.barteringProgress;
        }
        if (!barterBlockEntity.isBartering()) {
            BarterBlockEntity.tryBarter(level, barterBlockEntity);
        }
        barterBlockEntity.markUpdated();
    }

    private static void tryBarter(class_1937 level, BarterBlockEntity barterBlockEntity) {
        if (level.field_9236) {
            return;
        }
        if (barterBlockEntity.isInputEmpty()) {
            barterBlockEntity.resetIfNeed();
            return;
        }
        barterBlockEntity.resetIfNeed();
        class_52 loottable = level.method_8503().method_58576().method_58295(class_39.field_22402);
        switch (barterBlockEntity.piglinCount) {
            case 1: {
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackA, barterBlockEntity, loottable);
                break;
            }
            case 2: {
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackA, barterBlockEntity, loottable);
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackB, barterBlockEntity, loottable);
                break;
            }
            case 3: {
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackA, barterBlockEntity, loottable);
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackB, barterBlockEntity, loottable);
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackC, barterBlockEntity, loottable);
                break;
            }
            case 4: {
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackA, barterBlockEntity, loottable);
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackB, barterBlockEntity, loottable);
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackC, barterBlockEntity, loottable);
                BarterBlockEntity.doBarter(barterBlockEntity.piglinStackD, barterBlockEntity, loottable);
            }
        }
        barterBlockEntity.resetIfNeed();
    }

    private static void doBarter(class_1799 stack, BarterBlockEntity barterBlockEntity, class_52 loottable) {
        if (!stack.method_7960()) {
            class_4836 piglin = (class_4836)PickablePiglins.CACHE.getEntity(stack, barterBlockEntity.field_11863);
            if (piglin == null) {
                return;
            }
            if (BarterBlockEntity.tryAddLootFromPool((List<class_1799>)loottable.method_51878(new class_8567.class_8568((class_3218)barterBlockEntity.field_11863).method_51874(class_181.field_1226, (Object)piglin).method_51875(class_173.field_22403)), barterBlockEntity)) {
                barterBlockEntity.method_5434(0, 1);
            }
        }
    }

    private static boolean tryAddLootFromPool(List<class_1799> list, BarterBlockEntity barterBlockEntity) {
        if (list.isEmpty()) {
            return false;
        }
        int failedStacks = 0;
        for (class_1799 stack : list) {
            if (barterBlockEntity.tryAddOutput(stack)) continue;
            ++failedStacks;
        }
        return failedStacks != list.size();
    }

    private boolean tryAddOutput(class_1799 stackToAdd) {
        for (int i = 1; i < this.items.size(); ++i) {
            class_1799 itemStack = (class_1799)this.items.get(i);
            if (itemStack.method_7960()) {
                this.items.set(i, (Object)stackToAdd);
                return true;
            }
            if (!class_1799.method_31577((class_1799)itemStack, (class_1799)stackToAdd)) continue;
            if (stackToAdd.method_7947() >= itemStack.method_7914()) {
                return false;
            }
            int count = Math.min(itemStack.method_7947() + stackToAdd.method_7947(), itemStack.method_7914());
            stackToAdd.method_7939(count);
            this.items.set(i, (Object)stackToAdd);
            return true;
        }
        return false;
    }

    public boolean isBartering() {
        return this.barteringProgress > 0;
    }

    public double getBarteringProgress() {
        return (double)(this.barteringProgress * 13) / (double)PickablePiglins.CONFIG.BarterCooldown;
    }

    protected void resetIfNeed() {
        this.barteringProgress = PickablePiglins.CONFIG.BarterCooldown;
    }

    private boolean hasMaxPiglins() {
        return this.getEntityCount() == 4;
    }

    public boolean hasNoPiglins() {
        return this.getEntityCount() == 0;
    }

    private boolean foundPiglin(UUID uuid) {
        return switch (this.getEntityCount()) {
            case 1 -> this.piglinA.method_5667().equals(uuid);
            case 2 -> {
                if (this.piglinA.method_5667().equals(uuid) || this.piglinB.method_5667().equals(uuid)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (this.piglinA.method_5667().equals(uuid) || this.piglinB.method_5667().equals(uuid) || this.piglinC.method_5667().equals(uuid)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (this.piglinA.method_5667().equals(uuid) || this.piglinB.method_5667().equals(uuid) || this.piglinC.method_5667().equals(uuid) || this.piglinD.method_5667().equals(uuid)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public class_4836 getPiglinRenderer(int piglinIndex) {
        if (piglinIndex == 1) {
            if (this.piglinA != null) {
                return this.piglinA;
            }
            this.piglinA = this.getRendererFromStack(this.piglinStackA);
            return this.piglinA;
        }
        if (piglinIndex == 2) {
            if (this.piglinB != null) {
                return this.piglinB;
            }
            this.piglinB = this.getRendererFromStack(this.piglinStackB);
            return this.piglinB;
        }
        if (piglinIndex == 3) {
            if (this.piglinC != null) {
                return this.piglinC;
            }
            this.piglinC = this.getRendererFromStack(this.piglinStackC);
            return this.piglinC;
        }
        if (piglinIndex == 4) {
            if (this.piglinD != null) {
                return this.piglinD;
            }
            this.piglinD = this.getRendererFromStack(this.piglinStackD);
            return this.piglinD;
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    private class_4836 getRendererFromStack(class_1799 stack) {
        if (this.field_11863 == null) {
            return null;
        }
        class_4836 piglin = (class_4836)PickablePiglins.CACHE.getEntity(stack, this.field_11863);
        if (piglin == null) {
            EntityDataComponent data = PickablePiglins.CACHE.getData(stack, this.field_11863);
            if (data == null) {
                return null;
            }
            class_2487 tag = data.getTag();
            if (tag.method_25928("UUID")) {
                RequestUpdatePacket.sendToServer((UUID)tag.method_25926("UUID"), (String)"piglin");
            }
            return null;
        }
        return piglin;
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        if (compoundTag == null) {
            return;
        }
        if (compoundTag.method_10545("bartering")) {
            this.barteringProgress = compoundTag.method_10550("bartering");
        }
        this.piglinCount = 0;
        this.piglinStackA = class_1799.field_8037;
        this.piglinStackB = class_1799.field_8037;
        this.piglinStackC = class_1799.field_8037;
        this.piglinStackD = class_1799.field_8037;
        this.piglinA = null;
        this.piglinB = null;
        this.piglinC = null;
        this.piglinD = null;
        if (compoundTag.method_10545("barter_version")) {
            compoundTag.method_10569("version", compoundTag.method_10550("barter_version"));
            compoundTag.method_10551("barter_version");
        }
        if (!compoundTag.method_10545("version") || compoundTag.method_10550("version") != Alexandria.VERSION) {
            if (compoundTag.method_10545("piglins")) {
                class_2499 listTag = compoundTag.method_10554("piglins", 10);
                int listTagSize = listTag.size();
                for (int i = 0; i < listTagSize; ++i) {
                    class_2520 entry = listTag.method_10534(i);
                    if (!(entry instanceof class_2487)) continue;
                    class_2487 tag = (class_2487)entry;
                    if (i == 0) {
                        this.piglinStackA = PickablePiglins.CACHE.recreateItemStack(tag, provider, this.field_11863);
                        this.piglinA = (class_4836)PickablePiglins.CACHE.getEntity(this.piglinStackA, this.field_11863);
                        if (this.piglinStackA.method_7960()) continue;
                        this.piglinCount = Math.min(this.piglinCount + 1, 4);
                        continue;
                    }
                    if (i == 1) {
                        this.piglinStackB = PickablePiglins.CACHE.recreateItemStack(tag, provider, this.field_11863);
                        this.piglinB = (class_4836)PickablePiglins.CACHE.getEntity(this.piglinStackB, this.field_11863);
                        if (this.piglinStackB.method_7960()) continue;
                        this.piglinCount = Math.min(this.piglinCount + 1, 4);
                        continue;
                    }
                    if (i == 2) {
                        this.piglinStackC = PickablePiglins.CACHE.recreateItemStack(tag, provider, this.field_11863);
                        this.piglinC = (class_4836)PickablePiglins.CACHE.getEntity(this.piglinStackC, this.field_11863);
                        if (this.piglinStackC.method_7960()) continue;
                        this.piglinCount = Math.min(this.piglinCount + 1, 4);
                        continue;
                    }
                    if (i != 3) continue;
                    this.piglinStackD = PickablePiglins.CACHE.recreateItemStack(tag, provider, this.field_11863);
                    this.piglinD = (class_4836)PickablePiglins.CACHE.getEntity(this.piglinStackD, this.field_11863);
                    if (this.piglinStackD.method_7960()) continue;
                    this.piglinCount = Math.min(this.piglinCount + 1, 4);
                }
            }
        } else {
            if (compoundTag.method_10545(piglinKeyA)) {
                this.piglinStackA = PickablePiglins.CACHE.recreateItemStack(compoundTag.method_10562(piglinKeyA), provider, this.field_11863);
                this.piglinA = (class_4836)PickablePiglins.CACHE.getEntity(this.piglinStackA, this.field_11863);
                if (!this.piglinStackA.method_7960()) {
                    this.piglinCount = Math.min(this.piglinCount + 1, 4);
                }
            }
            if (compoundTag.method_10545(piglinKeyB)) {
                this.piglinStackB = PickablePiglins.CACHE.recreateItemStack(compoundTag.method_10562(piglinKeyB), provider, this.field_11863);
                this.piglinB = (class_4836)PickablePiglins.CACHE.getEntity(this.piglinStackB, this.field_11863);
                if (!this.piglinStackB.method_7960()) {
                    this.piglinCount = Math.min(this.piglinCount + 1, 4);
                }
            }
            if (compoundTag.method_10545(piglinKeyC)) {
                this.piglinStackC = PickablePiglins.CACHE.recreateItemStack(compoundTag.method_10562(piglinKeyC), provider, this.field_11863);
                this.piglinC = (class_4836)PickablePiglins.CACHE.getEntity(this.piglinStackC, this.field_11863);
                if (!this.piglinStackC.method_7960()) {
                    this.piglinCount = Math.min(this.piglinCount + 1, 4);
                }
            }
            if (compoundTag.method_10545(piglinKeyD)) {
                this.piglinStackD = PickablePiglins.CACHE.recreateItemStack(compoundTag.method_10562(piglinKeyD), provider, this.field_11863);
                this.piglinD = (class_4836)PickablePiglins.CACHE.getEntity(this.piglinStackD, this.field_11863);
                if (!this.piglinStackD.method_7960()) {
                    this.piglinCount = Math.min(this.piglinCount + 1, 4);
                }
            }
        }
    }

    public void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        if (((class_1799)this.items.get(0)).method_7960()) {
            compoundTag.method_10569("bartering", PickablePiglins.CONFIG.BarterCooldown);
        } else {
            compoundTag.method_10569("bartering", this.barteringProgress);
        }
        if (!this.piglinStackA.method_7960()) {
            compoundTag.method_10566(piglinKeyA, this.piglinStackA.method_57358(provider));
        }
        if (!this.piglinStackB.method_7960()) {
            compoundTag.method_10566(piglinKeyB, this.piglinStackB.method_57358(provider));
        }
        if (!this.piglinStackC.method_7960()) {
            compoundTag.method_10566(piglinKeyC, this.piglinStackC.method_57358(provider));
        }
        if (!this.piglinStackD.method_7960()) {
            compoundTag.method_10566(piglinKeyD, this.piglinStackD.method_57358(provider));
        }
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return new BarterContainer(i, this.field_11863, this.field_11867, player.method_31548(), player);
    }
}

