/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepiglins.blocks;

import com.shiftthedev.pickablepiglins.blocks.BarterBlock;
import com.shiftthedev.pickablepiglins.blocks.BarterBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4836;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_898;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class BarterRenderer
implements class_827<BarterBlockEntity> {
    private class_898 entityRenderer;
    private class_918 itemRenderer;
    private static final class_1799 INVALID_STACK = new class_1799((class_1935)class_1802.field_8077);

    public void render(BarterBlockEntity blockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
        if (this.entityRenderer == null) {
            this.entityRenderer = class_310.method_1551().method_1561();
        }
        if (this.itemRenderer == null) {
            this.itemRenderer = class_310.method_1551().method_1480();
        }
        if (blockEntity.hasNoPiglins()) {
            return;
        }
        switch (blockEntity.getEntityCount()) {
            case 1: {
                this.renderSingle(blockEntity.getPiglinRenderer(1), poseStack, multiBufferSource, i, blockEntity);
                break;
            }
            case 2: {
                this.renderDouble(blockEntity.getPiglinRenderer(1), blockEntity.getPiglinRenderer(2), poseStack, multiBufferSource, i, blockEntity);
                break;
            }
            case 3: {
                this.renderTriple(blockEntity.getPiglinRenderer(1), blockEntity.getPiglinRenderer(2), blockEntity.getPiglinRenderer(3), poseStack, multiBufferSource, i, blockEntity);
                break;
            }
            case 4: {
                this.renderQuad(blockEntity.getPiglinRenderer(1), blockEntity.getPiglinRenderer(2), blockEntity.getPiglinRenderer(3), blockEntity.getPiglinRenderer(4), poseStack, multiBufferSource, i, blockEntity);
            }
        }
    }

    private void renderSingle(class_4836 piglin, class_4587 poseStack, class_4597 multiBufferSource, int light, BarterBlockEntity blockEntity) {
        if (piglin == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 1, 1);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 1, 1)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
            return;
        }
        poseStack.method_22903();
        float s = 0.5f / piglin.method_17682();
        this.translate(poseStack, blockEntity, 1, 1);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 1, 1)));
        poseStack.method_22903();
        poseStack.method_22905(s, s, s);
        this.entityRenderer.method_3948(false);
        this.entityRenderer.method_3954((class_1297)piglin, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
        this.entityRenderer.method_3948(true);
        poseStack.method_22909();
        poseStack.method_22909();
    }

    private void renderDouble(class_4836 piglinA, class_4836 piglinB, class_4587 poseStack, class_4597 multiBufferSource, int light, BarterBlockEntity blockEntity) {
        float s = 0.0f;
        if (piglinA == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 1, 2);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 1, 2)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
        } else {
            s = 0.5f / piglinA.method_17682();
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 1, 2);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 1, 2)));
            poseStack.method_22903();
            poseStack.method_22905(s, s, s);
            this.entityRenderer.method_3948(false);
            this.entityRenderer.method_3954((class_1297)piglinA, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
            this.entityRenderer.method_3948(true);
            poseStack.method_22909();
            poseStack.method_22909();
        }
        if (piglinB == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 2, 2);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 2, 2)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
        } else {
            s = 0.5f / piglinB.method_17682();
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 2, 2);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 2, 2)));
            poseStack.method_22903();
            poseStack.method_22905(s, s, s);
            this.entityRenderer.method_3948(false);
            this.entityRenderer.method_3954((class_1297)piglinB, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
            this.entityRenderer.method_3948(true);
            poseStack.method_22909();
            poseStack.method_22909();
        }
    }

    private void renderTriple(class_4836 piglinA, class_4836 piglinB, class_4836 piglinC, class_4587 poseStack, class_4597 multiBufferSource, int light, BarterBlockEntity blockEntity) {
        float s = 0.0f;
        if (piglinA == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 1, 3);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 1, 3)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
        } else {
            s = 0.5f / piglinA.method_17682();
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 1, 3);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 1, 3)));
            poseStack.method_22903();
            poseStack.method_22905(s, s, s);
            this.entityRenderer.method_3948(false);
            this.entityRenderer.method_3954((class_1297)piglinA, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
            this.entityRenderer.method_3948(true);
            poseStack.method_22909();
            poseStack.method_22909();
        }
        if (piglinB == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 2, 3);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 2, 3)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
        } else {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 2, 3);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 2, 3)));
            poseStack.method_22903();
            poseStack.method_22905(s, s, s);
            this.entityRenderer.method_3948(false);
            this.entityRenderer.method_3954((class_1297)piglinB, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
            this.entityRenderer.method_3948(true);
            poseStack.method_22909();
            poseStack.method_22909();
        }
        if (piglinC == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 3, 3);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 3, 3)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
        } else {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 3, 3);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 3, 3)));
            poseStack.method_22903();
            poseStack.method_22905(s, s, s);
            this.entityRenderer.method_3948(false);
            this.entityRenderer.method_3954((class_1297)piglinC, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
            this.entityRenderer.method_3948(true);
            poseStack.method_22909();
            poseStack.method_22909();
        }
    }

    private void renderQuad(class_4836 piglinA, class_4836 piglinB, class_4836 piglinC, class_4836 piglinD, class_4587 poseStack, class_4597 multiBufferSource, int light, BarterBlockEntity blockEntity) {
        float s = 0.0f;
        if (piglinA == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 1, 4);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 1, 4)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
        } else {
            s = 0.5f / piglinA.method_17682();
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 1, 4);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 1, 4)));
            poseStack.method_22903();
            poseStack.method_22905(s, s, s);
            this.entityRenderer.method_3948(false);
            this.entityRenderer.method_3954((class_1297)piglinA, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
            this.entityRenderer.method_3948(true);
            poseStack.method_22909();
            poseStack.method_22909();
        }
        if (piglinB == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 2, 4);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 2, 4)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
        } else {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 2, 4);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 2, 4)));
            poseStack.method_22903();
            poseStack.method_22905(s, s, s);
            this.entityRenderer.method_3948(false);
            this.entityRenderer.method_3954((class_1297)piglinB, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
            this.entityRenderer.method_3948(true);
            poseStack.method_22909();
            poseStack.method_22909();
        }
        if (piglinC == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 3, 4);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 3, 4)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
        } else {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 3, 4);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 3, 4)));
            poseStack.method_22903();
            poseStack.method_22905(s, s, s);
            this.entityRenderer.method_3948(false);
            this.entityRenderer.method_3954((class_1297)piglinC, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
            this.entityRenderer.method_3948(true);
            poseStack.method_22909();
            poseStack.method_22909();
        }
        if (piglinD == null) {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 4, 4);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 4, 4)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, light, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
        } else {
            poseStack.method_22903();
            this.translate(poseStack, blockEntity, 4, 4);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getRotation(blockEntity, 4, 4)));
            poseStack.method_22903();
            poseStack.method_22905(s, s, s);
            this.entityRenderer.method_3948(false);
            this.entityRenderer.method_3954((class_1297)piglinD, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
            this.entityRenderer.method_3948(true);
            poseStack.method_22909();
            poseStack.method_22909();
        }
    }

    private void renderBorked(class_4587 poseStack, int light, class_4597 multiBufferSource) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.5, 0.0);
        this.itemRenderer.method_23178(INVALID_STACK, class_811.field_4317, light, 0, poseStack, multiBufferSource, null, light);
        poseStack.method_22909();
    }

    public float getRotation(BarterBlockEntity blockEntity, int piglinIndex, int piglinCount) {
        switch ((class_2350)blockEntity.method_11010().method_11654((class_2769)BarterBlock.FACING)) {
            case field_11043: {
                if (piglinCount == 1) {
                    return 180.0f;
                }
                if (piglinCount == 2) {
                    return piglinIndex == 1 ? -90.0f : (piglinIndex == 2 ? 90.0f : 0.0f);
                }
                if (piglinCount == 3) {
                    return piglinIndex == 1 ? -135.0f : (piglinIndex == 2 ? 135.0f : (piglinIndex == 3 ? 0.0f : 0.0f));
                }
                if (piglinCount == 4) {
                    return piglinIndex == 1 ? -135.0f : (piglinIndex == 2 ? 135.0f : (piglinIndex == 3 ? 45.0f : (piglinIndex == 4 ? -45.0f : 0.0f)));
                }
                return 0.0f;
            }
            case field_11039: {
                if (piglinCount == 1) {
                    return 90.0f;
                }
                if (piglinCount == 2) {
                    return piglinIndex == 1 ? 180.0f : (piglinIndex == 2 ? 0.0f : 0.0f);
                }
                if (piglinCount == 3) {
                    return piglinIndex == 1 ? 135.0f : (piglinIndex == 2 ? 45.0f : (piglinIndex == 3 ? -90.0f : 0.0f));
                }
                if (piglinCount == 4) {
                    return piglinIndex == 1 ? 135.0f : (piglinIndex == 2 ? 45.0f : (piglinIndex == 3 ? -45.0f : (piglinIndex == 4 ? -135.0f : 0.0f)));
                }
                return 0.0f;
            }
            case field_11034: {
                if (piglinCount == 1) {
                    return -90.0f;
                }
                if (piglinCount == 2) {
                    return piglinIndex == 1 ? 0.0f : (piglinIndex == 2 ? 180.0f : 0.0f);
                }
                if (piglinCount == 3) {
                    return piglinIndex == 1 ? -45.0f : (piglinIndex == 2 ? -135.0f : (piglinIndex == 3 ? 90.0f : 0.0f));
                }
                if (piglinCount == 4) {
                    return piglinIndex == 1 ? -45.0f : (piglinIndex == 2 ? -135.0f : (piglinIndex == 3 ? 135.0f : (piglinIndex == 4 ? 45.0f : 0.0f)));
                }
                return 0.0f;
            }
            case field_11035: {
                if (piglinCount == 1) {
                    return 0.0f;
                }
                if (piglinCount == 2) {
                    return piglinIndex == 1 ? 90.0f : (piglinIndex == 2 ? -90.0f : 0.0f);
                }
                if (piglinCount == 3) {
                    return piglinIndex == 1 ? 45.0f : (piglinIndex == 2 ? -45.0f : (piglinIndex == 3 ? 180.0f : 0.0f));
                }
                if (piglinCount == 4) {
                    return piglinIndex == 1 ? 45.0f : (piglinIndex == 2 ? -45.0f : (piglinIndex == 3 ? -135.0f : (piglinIndex == 4 ? 135.0f : 0.0f)));
                }
                return 0.0f;
            }
        }
        return 0.0f;
    }

    private void translate(class_4587 poseStack, BarterBlockEntity blockEntity, int piglinIndex, int piglinCount) {
        if (piglinCount == 1) {
            poseStack.method_22904(0.5, 0.25, 0.5);
            return;
        }
        switch ((class_2350)blockEntity.method_11010().method_11654((class_2769)BarterBlock.FACING)) {
            case field_11043: {
                if (piglinCount == 2) {
                    if (piglinIndex == 1) {
                        poseStack.method_22904(0.25, 0.25, 0.5);
                        return;
                    }
                    if (piglinIndex == 2) {
                        poseStack.method_22904(0.75, 0.25, 0.5);
                        return;
                    }
                    return;
                }
                if (piglinCount == 3) {
                    if (piglinIndex == 1) {
                        poseStack.method_22904(0.25, 0.25, 0.75);
                        return;
                    }
                    if (piglinIndex == 2) {
                        poseStack.method_22904(0.75, 0.25, 0.75);
                        return;
                    }
                    if (piglinIndex == 3) {
                        poseStack.method_22904(0.5, 0.25, 0.25);
                        return;
                    }
                    return;
                }
                if (piglinCount != 4) break;
                if (piglinIndex == 1) {
                    poseStack.method_22904(0.25, 0.25, 0.75);
                    return;
                }
                if (piglinIndex == 2) {
                    poseStack.method_22904(0.75, 0.25, 0.75);
                    return;
                }
                if (piglinIndex == 3) {
                    poseStack.method_22904(0.75, 0.25, 0.25);
                    return;
                }
                if (piglinIndex == 4) {
                    poseStack.method_22904(0.25, 0.25, 0.25);
                    return;
                }
                return;
            }
            case field_11039: {
                if (piglinCount == 2) {
                    if (piglinIndex == 1) {
                        poseStack.method_22904(0.5, 0.25, 0.75);
                        return;
                    }
                    if (piglinIndex == 2) {
                        poseStack.method_22904(0.5, 0.25, 0.25);
                        return;
                    }
                    return;
                }
                if (piglinCount == 3) {
                    if (piglinIndex == 1) {
                        poseStack.method_22904(0.75, 0.25, 0.75);
                        return;
                    }
                    if (piglinIndex == 2) {
                        poseStack.method_22904(0.75, 0.25, 0.25);
                        return;
                    }
                    if (piglinIndex == 3) {
                        poseStack.method_22904(0.25, 0.25, 0.5);
                        return;
                    }
                    return;
                }
                if (piglinCount != 4) break;
                if (piglinIndex == 1) {
                    poseStack.method_22904(0.75, 0.25, 0.75);
                    return;
                }
                if (piglinIndex == 2) {
                    poseStack.method_22904(0.75, 0.25, 0.25);
                    return;
                }
                if (piglinIndex == 3) {
                    poseStack.method_22904(0.25, 0.25, 0.25);
                    return;
                }
                if (piglinIndex == 4) {
                    poseStack.method_22904(0.25, 0.25, 0.75);
                    return;
                }
                return;
            }
            case field_11034: {
                if (piglinCount == 2) {
                    if (piglinIndex == 1) {
                        poseStack.method_22904(0.5, 0.25, 0.25);
                        return;
                    }
                    if (piglinIndex == 2) {
                        poseStack.method_22904(0.5, 0.25, 0.75);
                        return;
                    }
                    return;
                }
                if (piglinCount == 3) {
                    if (piglinIndex == 1) {
                        poseStack.method_22904(0.25, 0.25, 0.25);
                        return;
                    }
                    if (piglinIndex == 2) {
                        poseStack.method_22904(0.25, 0.25, 0.75);
                        return;
                    }
                    if (piglinIndex == 3) {
                        poseStack.method_22904(0.75, 0.25, 0.5);
                        return;
                    }
                    return;
                }
                if (piglinCount != 4) break;
                if (piglinIndex == 1) {
                    poseStack.method_22904(0.25, 0.25, 0.25);
                    return;
                }
                if (piglinIndex == 2) {
                    poseStack.method_22904(0.25, 0.25, 0.75);
                    return;
                }
                if (piglinIndex == 3) {
                    poseStack.method_22904(0.75, 0.25, 0.75);
                    return;
                }
                if (piglinIndex == 4) {
                    poseStack.method_22904(0.75, 0.25, 0.25);
                    return;
                }
                return;
            }
            case field_11035: {
                if (piglinCount == 2) {
                    if (piglinIndex == 1) {
                        poseStack.method_22904(0.75, 0.25, 0.5);
                        return;
                    }
                    if (piglinIndex == 2) {
                        poseStack.method_22904(0.25, 0.25, 0.5);
                        return;
                    }
                    return;
                }
                if (piglinCount == 3) {
                    if (piglinIndex == 1) {
                        poseStack.method_22904(0.75, 0.25, 0.25);
                        return;
                    }
                    if (piglinIndex == 2) {
                        poseStack.method_22904(0.25, 0.25, 0.25);
                        return;
                    }
                    if (piglinIndex == 3) {
                        poseStack.method_22904(0.5, 0.25, 0.75);
                        return;
                    }
                    return;
                }
                if (piglinCount != 4) break;
                if (piglinIndex == 1) {
                    poseStack.method_22904(0.75, 0.25, 0.25);
                    return;
                }
                if (piglinIndex == 2) {
                    poseStack.method_22904(0.25, 0.25, 0.25);
                    return;
                }
                if (piglinIndex == 3) {
                    poseStack.method_22904(0.25, 0.25, 0.75);
                    return;
                }
                if (piglinIndex == 4) {
                    poseStack.method_22904(0.75, 0.25, 0.75);
                    return;
                }
                return;
            }
        }
    }
}

