/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepiglins.data;

import com.shiftthedev.alexandria.Alexandria;
import com.shiftthedev.alexandria.data.CachedEntities;
import com.shiftthedev.alexandria.data.EntityDataComponent;
import com.shiftthedev.alexandria.data.EntityInfo;
import com.shiftthedev.alexandria.registry.CommonRegistry;
import com.shiftthedev.pickablepiglins.PPRegistry;
import com.shiftthedev.pickablepiglins.data.PiglinDataComponent;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_4836;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class CachedPiglins
extends CachedEntities<class_4836, EntityInfo<class_4836>> {
    public CachedPiglins() {
        super(EntityInfo::new);
    }

    public String getKey() {
        return "piglin";
    }

    protected void loadExtraData(class_4836 entity, class_2487 tag) {
        if (tag.method_10545("IsBaby")) {
            entity.method_7217(tag.method_10577("IsBaby"));
        }
    }

    protected class_1799 fixIfNeeded(class_1799 stack, class_1937 level) {
        if (stack.method_57826((class_9331)PPRegistry.PIGLIN_DATA_COMPONENT.get())) {
            PiglinDataComponent oldData = (PiglinDataComponent)stack.method_57824((class_9331)PPRegistry.PIGLIN_DATA_COMPONENT.get());
            stack.method_57379((class_9331)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)new EntityDataComponent(oldData.tag, oldData.version));
            stack.method_57381((class_9331)PPRegistry.PIGLIN_DATA_COMPONENT.get());
        }
        return stack;
    }

    public void updateOldStack(class_1799 stack, class_1937 level) {
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (level.field_9236) {
            return;
        }
        class_4836 piglin = new class_4836(class_1299.field_22281, level);
        class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49628);
        if (customData == null) {
            class_2487 tag = new class_2487();
            piglin.method_5647(tag);
            tag.method_10582("entity_type", class_1299.method_5890((class_1299)piglin.method_5864()).toString());
            EntityDataComponent data = new EntityDataComponent(tag, Alexandria.VERSION);
            stack.method_57379((class_9331)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)data);
            return;
        }
        class_2487 customTag = customData.method_57461();
        if (customTag.method_10545("updating")) {
            customTag.method_10551("updating");
        }
        if (!customTag.method_10573("piglin_info", 10)) {
            class_2487 tag = new class_2487();
            piglin.method_5647(tag);
            tag.method_10582("entity_type", class_1299.method_5890((class_1299)piglin.method_5864()).toString());
            EntityDataComponent data = new EntityDataComponent(tag, Alexandria.VERSION);
            stack.method_57379((class_9331)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)data);
            return;
        }
        class_2487 oldTag = customTag.method_10562("piglin_info");
        customTag.method_10551("piglin_info");
        if (customData.method_57458()) {
            stack.method_57381(class_9334.field_49628);
        } else {
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customTag));
        }
        piglin.method_5749(oldTag);
        if (stack.method_57826(class_9334.field_49631)) {
            piglin.method_5665((class_2561)stack.method_57824(class_9334.field_49631));
        }
        class_2487 newTag = new class_2487();
        piglin.method_5647(newTag);
        newTag.method_10582("entity_type", class_1299.method_5890((class_1299)piglin.method_5864()).toString());
        EntityDataComponent data = EntityDataComponent.fromTag((class_2487)newTag);
        stack.method_57379((class_9331)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)data);
        this.cache((class_1309)piglin);
    }

    public void save(Path path) {
        class_2499 listTag = new class_2499();
        TreeMap<UUID, EntityInfo> tempMap = new TreeMap<UUID, EntityInfo>();
        for (Map.Entry piglinEntry : this.cachedEntities.entrySet()) {
            class_2487 entryTag = new class_2487();
            entryTag.method_25927("Key", (UUID)piglinEntry.getKey());
            entryTag.method_10566("Value", (class_2520)((EntityInfo)piglinEntry.getValue()).save(new class_2487()));
            listTag.add((Object)entryTag);
            tempMap.put((UUID)piglinEntry.getKey(), (EntityInfo)piglinEntry.getValue());
        }
        this.cachedEntities.clear();
        this.cachedEntities = new TreeMap();
        this.cachedEntities.putAll(tempMap);
        class_2487 tagToSave = new class_2487();
        tagToSave.method_10566("piglins", (class_2520)listTag);
        tagToSave.method_10569("version", Alexandria.VERSION);
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        Path file = path.resolve("piglins.shift");
        try {
            class_2507.method_30614((class_2487)tagToSave, (Path)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void load(Path path, MinecraftServer server) {
        class_2487 tag;
        this.cachedEntities = new TreeMap();
        Path file = path.resolve("piglins.shift");
        if (!file.toFile().exists()) {
            return;
        }
        try {
            tag = class_2507.method_30613((Path)file, (class_2505)class_2505.method_53898());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (tag == null) {
            return;
        }
        if (!tag.method_10545("piglins")) {
            return;
        }
        this.cachedEntities.clear();
        class_2499 listTag = tag.method_10554("piglins", 10);
        if (!tag.method_10545("version") || tag.method_10550("version") != Alexandria.VERSION) {
            for (class_2520 entry : listTag) {
                if (!(entry instanceof class_2487)) continue;
                class_2487 entryTag = (class_2487)entry;
                class_2487 value = entryTag.method_10562("Value");
                UUID piglinUUID = entryTag.method_25926("Key");
                class_4836 piglin = (class_4836)this.createEntity(piglinUUID, value, overworldLevel);
                this.cachedEntities.put(piglinUUID, new EntityInfo((class_1309)piglin));
            }
        } else {
            for (class_2520 entry : listTag) {
                if (!(entry instanceof class_2487)) continue;
                class_2487 entryTag = (class_2487)entry;
                class_2487 value = entryTag.method_10562("Value");
                UUID piglinUUID = entryTag.method_25926("Key");
                EntityInfo entityInfo = this.createEntityInfo(null);
                entityInfo.load(piglinUUID, value, overworldLevel);
                this.cachedEntities.put(piglinUUID, entityInfo);
            }
        }
    }
}

