/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.data;

import de.bigbull.vibranium.Vibranium;
import de.bigbull.vibranium.data.lang.ModDeLangProvider;
import de.bigbull.vibranium.data.lang.ModEnLangProvider;
import de.bigbull.vibranium.data.loot.ModGlobalLootModifiersProvider;
import de.bigbull.vibranium.data.loottable.ModLootTables;
import de.bigbull.vibranium.data.recipe.MainModRecipeProvider;
import de.bigbull.vibranium.data.tag.ModBlockTagsProvider;
import de.bigbull.vibranium.data.tag.ModItemTagsProvider;
import de.bigbull.vibranium.data.texture.ModBlockStateProvider;
import de.bigbull.vibranium.data.texture.ModItemStateProvider;
import de.bigbull.vibranium.data.worldgen.ModWorldGenProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGenerators {
    public static void gatherData(GatherDataEvent event) {
        try {
            DataGenerator generator = event.getGenerator();
            PackOutput output = generator.getPackOutput();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            generator.addProvider(true, (DataProvider)new ModEnLangProvider(output));
            generator.addProvider(true, (DataProvider)new ModDeLangProvider(output));
            generator.addProvider(true, (DataProvider)new ModItemStateProvider(output, existingFileHelper));
            generator.addProvider(true, (DataProvider)new ModBlockStateProvider(output, existingFileHelper));
            ModBlockTagsProvider modBlockTagsProvider = new ModBlockTagsProvider(output, event.getLookupProvider(), existingFileHelper);
            generator.addProvider(true, (DataProvider)modBlockTagsProvider);
            generator.addProvider(true, (DataProvider)new ModItemTagsProvider(output, event.getLookupProvider(), modBlockTagsProvider, existingFileHelper));
            generator.addProvider(true, (DataProvider)new ModLootTables(output, event.getLookupProvider()));
            generator.addProvider(true, (DataProvider)new ModWorldGenProvider(output, event.getLookupProvider()));
            generator.addProvider(true, (DataProvider)new ModGlobalLootModifiersProvider(output, event.getLookupProvider()));
            generator.addProvider(true, (DataProvider)new MainModRecipeProvider(generator, event.getLookupProvider()));
        }
        catch (RuntimeException e) {
            Vibranium.logger.error("Failed to generate data", (Throwable)e);
        }
    }
}

