/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.data.recipe.provider.custom;

import de.bigbull.vibranium.init.ItemInit;
import de.bigbull.vibranium.init.TagsInit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

@EventBusSubscriber(modid="vibranium")
public class CustomBrewingRecipe
implements IBrewingRecipe {
    private final Predicate<ItemStack> inputPredicate;
    private final TagKey<Item> catalystTag;
    private final Supplier<? extends Item> outputItem;

    public CustomBrewingRecipe(Predicate<ItemStack> inputPredicate, TagKey<Item> catalystTag, Supplier<? extends Item> outputItem) {
        this.inputPredicate = inputPredicate;
        this.catalystTag = catalystTag;
        this.outputItem = outputItem;
    }

    @SubscribeEvent
    public static void onRegisterBrewingRecipe(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addRecipe((IBrewingRecipe)new CustomBrewingRecipe(input -> {
            if (input.getItem() != Items.POTION) {
                return false;
            }
            PotionContents contents = (PotionContents)input.get(DataComponents.POTION_CONTENTS);
            if (contents == null) {
                return false;
            }
            return contents.is(Potions.AWKWARD);
        }, TagsInit.ItemTagsInit.HEART_SHAPED_HERB_TAG, (Supplier<? extends Item>)ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR));
        builder.addRecipe((IBrewingRecipe)new CustomBrewingRecipe(input -> input.getItem() == ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR.get(), (TagKey<Item>)Tags.Items.DUSTS_REDSTONE, (Supplier<? extends Item>)ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR_EXTENDED));
        builder.addRecipe((IBrewingRecipe)new CustomBrewingRecipe(input -> input.getItem() == ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR.get(), (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, (Supplier<? extends Item>)ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR_ENHANCED));
    }

    public boolean isInput(ItemStack input) {
        return this.inputPredicate.test(input);
    }

    public boolean isIngredient(ItemStack ingredient) {
        return ingredient.is(this.catalystTag);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? new ItemStack((ItemLike)this.outputItem.get()) : ItemStack.EMPTY;
    }
}

