/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.data.texture;

import de.bigbull.vibranium.init.BlockInit;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "vibranium", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.normalBlock((Block)BlockInit.BLOCK_OF_RAW_VIBRANIUM.get());
        this.normalBlock((Block)BlockInit.DEPPSLATE_VIBRANIUM_ORE.get());
        this.normalBlock((Block)BlockInit.Vibranium_Block.get());
        this.normalBlock((Block)BlockInit.ENRICHED_VIBRANIUM_DIRT.get());
        this.farmlandBlock((Block)BlockInit.ENRICHED_VIBRANIUM_FARMLAND.get());
    }

    private void normalBlock(Block block) {
        ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)block);
        String path = blockKey.getPath();
        this.simpleBlock(block, (ModelFile)this.models().cubeAll(path, this.modLoc("block/" + path)));
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(this.modLoc("block/" + path)));
    }

    private void farmlandBlock(Block block) {
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder dryModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName, this.mcLoc("block/farmland"))).texture("dirt", this.modLoc("block/enriched_vibranium_dirt"))).texture("top", this.modLoc("block/enriched_vibranium_farmland"));
        ModelBuilder moistModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_moist", this.mcLoc("block/farmland_moist"))).texture("dirt", this.modLoc("block/enriched_vibranium_dirt"))).texture("top", this.modLoc("block/enriched_vibranium_farmland_moist"));
        IntegerProperty moisture = FarmBlock.MOISTURE;
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$farmlandBlock$0(moisture, (ModelFile)moistModel, (ModelFile)dryModel, arg_0));
        this.simpleBlockItem(block, (ModelFile)dryModel);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$farmlandBlock$0(IntegerProperty moisture, ModelFile moistModel, ModelFile dryModel, BlockState state) {
        int moistureValue = (Integer)state.getValue((Property)moisture);
        return ConfiguredModel.builder().modelFile(moistureValue > 0 ? moistModel : dryModel).build();
    }
}

