/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.data.worldgen.ore;

import de.bigbull.vibranium.config.VibraniumConfigValues;
import de.bigbull.vibranium.data.worldgen.ore.ModConfiguredFeatures;
import de.bigbull.vibranium.data.worldgen.ore.ModOrePlacement;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ModPlacedFeatures {
    public static ResourceKey<PlacedFeature> VIBRANIUM_ORE = ModPlacedFeatures.createKey("vibranium_ore");
    private static final int VEINS_PER_CHUNK = VibraniumConfigValues.VEINS_PER_CHUNK;
    private static final int MAX_HEIGHT = VibraniumConfigValues.MAX_HEIGHT;
    private static final int MIN_HEIGHT = VibraniumConfigValues.MIN_HEIGHT;

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference holder = configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_VIBRANIUM_ORE);
        ModPlacedFeatures.register(context, VIBRANIUM_ORE, holder, ModOrePlacement.commonOrePlacements(VEINS_PER_CHUNK, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)MIN_HEIGHT), (VerticalAnchor)VerticalAnchor.absolute((int)MAX_HEIGHT))));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
        context.register(key, (Object)new PlacedFeature(feature, placementModifiers));
    }
}

