/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.entity.ai;

import de.bigbull.vibranium.entity.custom.VibraGolemEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class MoveToTargetItemGoal
extends Goal {
    private final VibraGolemEntity vibraGolem;
    private final double speedModifier;
    private final Predicate<ItemStack> items;

    public MoveToTargetItemGoal(VibraGolemEntity vibraGolem, double speedModifier, Predicate<ItemStack> items) {
        this.vibraGolem = vibraGolem;
        this.speedModifier = speedModifier;
        this.items = items;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.vibraGolem.getOwnerUUID() != null;
    }

    public void tick() {
        ItemEntity itemEntity = (ItemEntity)((ServerLevel)this.vibraGolem.level()).getEntity(this.vibraGolem.getOwnerUUID());
        if (itemEntity != null) {
            this.vibraGolem.getNavigation().moveTo((Entity)itemEntity, this.speedModifier);
            if ((double)this.vibraGolem.distanceTo((Entity)itemEntity) < 1.5) {
                this.vibraGolem.setOwnerUUID(null);
            }
        } else {
            this.vibraGolem.setOwnerUUID(null);
        }
    }

    public boolean canContinueToUse() {
        return this.vibraGolem.getOwnerUUID() != null && !this.vibraGolem.getNavigation().isDone();
    }

    public void stop() {
        this.vibraGolem.getNavigation().stop();
    }
}

