/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.entity.ai;

import de.bigbull.vibranium.entity.custom.VibraGolemEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;

public class PushGoal
extends Goal {
    private final VibraGolemEntity entity;
    private int pushCooldown;
    private int pushCooldown2;

    public PushGoal(VibraGolemEntity entity) {
        this.entity = entity;
        this.pushCooldown = 0;
        this.pushCooldown2 = 0;
        this.setFlags(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean canUse() {
        return this.entity.getHealth() < this.entity.getMaxHealth();
    }

    public void tick() {
        if (this.entity.hurtTime > 0 && this.entity.getLastDamageSource() != null && !(this.entity.getLastDamageSource().getDirectEntity() instanceof AbstractArrow)) {
            if (this.pushCooldown == 0 && (double)this.entity.getHealth() < (double)this.entity.getMaxHealth() * 0.5 && (double)this.entity.getHealth() > (double)this.entity.getMaxHealth() * 0.25) {
                this.pushNearbyEntities(1.5, 5.0);
                this.pushCooldown = 400;
            }
            if (this.pushCooldown2 == 0 && (double)this.entity.getHealth() < (double)this.entity.getMaxHealth() * 0.25) {
                this.pushNearbyEntities(3.0, 6.0);
                this.pushCooldown2 = 400;
            }
        }
        if (this.pushCooldown > 0) {
            --this.pushCooldown;
        }
        if (this.pushCooldown2 > 0) {
            --this.pushCooldown2;
        }
    }

    private void pushNearbyEntities(double strength, double radius) {
        LivingEntity livingEntity2;
        int particleCount = 120;
        double particleRadius = 4.0;
        this.entity.startRage();
        List entities = this.entity.level().getEntitiesOfClass(LivingEntity.class, this.entity.getBoundingBox().inflate(radius));
        for (LivingEntity livingEntity2 : entities) {
            if (livingEntity2 == this.entity || livingEntity2 instanceof VibraGolemEntity && ((VibraGolemEntity)livingEntity2).getOwner() == this.entity.getOwner()) continue;
            Vec3 direction = livingEntity2.position().subtract(this.entity.position()).normalize().scale(strength);
            livingEntity2.setDeltaMovement(livingEntity2.getDeltaMovement().add(direction.x, direction.y + 0.75, direction.z));
            livingEntity2.hurtMarked = true;
        }
        livingEntity2 = this.entity.level();
        if (livingEntity2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)livingEntity2;
            for (int i = 0; i < particleCount; ++i) {
                double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
                double xParticleOffset = particleRadius * Math.cos(angleOffset);
                double zParticleOffset = particleRadius * Math.sin(angleOffset);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.entity.getX() + xParticleOffset, this.entity.getY() - 0.1, this.entity.getZ() + zParticleOffset, 1, 0.0, 0.05, 0.0, 0.05);
            }
        }
        this.entity.level().playSound(null, this.entity.blockPosition(), SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

