/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.entity.ai;

import de.bigbull.vibranium.entity.custom.VibraGolemEntity;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class RegenerationGoal
extends Goal {
    private final VibraGolemEntity entity;
    private int regenCounter;

    public RegenerationGoal(VibraGolemEntity entity) {
        this.entity = entity;
        this.regenCounter = 0;
        this.setFlags(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean canUse() {
        return this.entity.getHealth() < this.entity.getMaxHealth();
    }

    public void tick() {
        if (this.entity.getHealth() < this.entity.getMaxHealth()) {
            ++this.regenCounter;
            if (this.regenCounter > 80) {
                this.regeneration(2.0f, ParticleTypes.HEART);
                this.regenCounter = 0;
            }
        }
    }

    private void regeneration(float healAmount, SimpleParticleType particle) {
        this.entity.heal(healAmount);
        Level level = this.entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 7; ++i) {
                double d0 = this.entity.getRandom().nextGaussian() * 0.02;
                double d1 = this.entity.getRandom().nextGaussian() * 0.02;
                double d2 = this.entity.getRandom().nextGaussian() * 0.02;
                serverLevel.sendParticles((ParticleOptions)particle, this.entity.getRandomX(1.0), this.entity.getRandomY() + 0.5, this.entity.getRandomZ(1.0), 1, d0, d1, d2, 0.05);
            }
        }
    }
}

