/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.bigbull.vibranium.entity.animations.ModAnimationDefinitions;
import de.bigbull.vibranium.entity.custom.VibraGolemEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class VibraGolemModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart vibra;
    private final ModelPart head;

    public VibraGolemModel(ModelPart root) {
        this.vibra = root.getChild("vibra");
        this.head = this.vibra.getChild("body").getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Vibra = partdefinition.addOrReplaceChild("vibra", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition body = Vibra.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-14.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).addBox(-8.0f, -12.0f, -6.0f, 16.0f, 12.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-28.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition R_Arm = body.addOrReplaceChild("R_Arm", CubeListBuilder.create().texOffs(50, 36).addBox(-9.0f, -4.0f, -6.0f, 9.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-13.0f, (float)-24.0f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)0.0436f));
        PartDefinition cube_r1 = R_Arm.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(6, 27).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-5.0f, (float)3.0f, (float)-0.0326f, (float)0.1199f, (float)-0.0351f));
        PartDefinition cube_r2 = R_Arm.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 48).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-5.0f, (float)-3.0f, (float)0.0054f, (float)-0.0061f, (float)-0.0432f));
        PartDefinition cube_r3 = R_Arm.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(46, 29).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-3.0f, (float)3.0f, (float)-0.0869f, (float)-0.0076f, (float)-0.0869f));
        PartDefinition cube_r4 = R_Arm.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(28, 65).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-3.0f, (float)-3.0f, (float)0.0432f, (float)0.0282f, (float)-0.0837f));
        PartDefinition cube_r5 = R_Arm.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(30, 93).addBox(-7.0f, -5.0f, -3.0f, 7.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)10.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition R_LowerArm = R_Arm.addOrReplaceChild("R_LowerArm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)14.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = R_LowerArm.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(66, 12).addBox(-8.0f, -6.0f, -4.0f, 9.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition L_Arm = body.addOrReplaceChild("L_Arm", CubeListBuilder.create().texOffs(48, 57).addBox(0.0f, -4.0f, -6.0f, 9.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)-24.0f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)-0.0436f));
        PartDefinition cube_r7 = L_Arm.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-5.0f, (float)3.0f, (float)-0.0326f, (float)-0.1199f, (float)0.0351f));
        PartDefinition cube_r8 = L_Arm.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 22).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-5.0f, (float)-3.0f, (float)0.0054f, (float)0.0061f, (float)0.0432f));
        PartDefinition cube_r9 = L_Arm.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(104, 24).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-3.0f, (float)3.0f, (float)-0.0869f, (float)0.0076f, (float)0.0869f));
        PartDefinition cube_r10 = L_Arm.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(104, 82).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-3.0f, (float)-3.0f, (float)0.0432f, (float)-0.0282f, (float)0.0837f));
        PartDefinition cube_r11 = L_Arm.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(0, 87).addBox(0.0f, -5.0f, -3.0f, 7.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)10.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition L_LowerArm = L_Arm.addOrReplaceChild("L_LowerArm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.0f, (float)14.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = L_LowerArm.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(0, 65).addBox(-1.0f, -6.0f, -4.0f, 9.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition F_Body = body.addOrReplaceChild("F_Body", CubeListBuilder.create().texOffs(64, 0).addBox(-5.0f, -29.0f, -3.0f, 10.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-13.0f, -27.0f, -5.0f, 26.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 48).addBox(-10.0f, -17.0f, -4.0f, 20.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(80, 34).addBox(-5.0f, -10.0f, -3.0f, 10.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(28, 78).addBox(-6.0f, -5.0f, -4.0f, 12.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = F_Body.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(104, 15).addBox(-2.9526f, 1.1735f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.0f, (float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition cube_r14 = F_Body.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(0, 65).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.0f, (float)-30.0f, (float)1.0f, (float)-0.029f, (float)-0.034f, (float)-0.0113f));
        PartDefinition cube_r15 = F_Body.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(62, 78).addBox(-1.9406f, -1.0009f, -1.989f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.0f, (float)-30.0f, (float)1.0f, (float)-0.0078f, (float)-0.0765f, (float)0.0298f));
        PartDefinition cube_r16 = F_Body.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(64, 0).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.0f, (float)-30.0f, (float)1.0f, (float)-0.029f, (float)0.034f, (float)0.0113f));
        PartDefinition cube_r17 = F_Body.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(46, 22).addBox(-2.0594f, -1.0009f, -1.989f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.0f, (float)-30.0f, (float)1.0f, (float)-0.0078f, (float)0.0765f, (float)-0.0298f));
        PartDefinition cube_r18 = F_Body.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(102, 92).addBox(-3.0474f, 1.1735f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.0f, (float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition L_Leg = Vibra.addOrReplaceChild("L_Leg", CubeListBuilder.create().texOffs(96, 69).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(84, 98).addBox(-3.0f, 3.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-14.0f, (float)1.0f));
        PartDefinition L_LowerLeg = L_Leg.addOrReplaceChild("L_LowerLeg", CubeListBuilder.create().texOffs(84, 49).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition R_Leg = Vibra.addOrReplaceChild("R_Leg", CubeListBuilder.create().texOffs(94, 2).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(60, 98).addBox(-3.0f, 3.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-14.0f, (float)1.0f));
        PartDefinition R_LowerLeg = R_Leg.addOrReplaceChild("R_LowerLeg", CubeListBuilder.create().texOffs(72, 78).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        this.animateWalk(ModAnimationDefinitions.VibraGolemAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(((VibraGolemEntity)entity).idleAnimationState, ModAnimationDefinitions.VibraGolemAnimation.idle, ageInTicks, 1.0f);
        this.animate(((VibraGolemEntity)entity).attackAnimationState, ModAnimationDefinitions.VibraGolemAnimation.attack, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch, float ageInTicks) {
        netHeadYaw = Mth.clamp((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int p_103113_, int p_103114_, int p_350308_) {
        this.vibra.render(poseStack, consumer, p_103113_, p_103114_, p_350308_);
    }

    public ModelPart root() {
        return this.vibra;
    }
}

