/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.event;

import de.bigbull.vibranium.entity.custom.VibraGolemEntity;
import de.bigbull.vibranium.init.BlockInit;
import de.bigbull.vibranium.init.ItemInit;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class VibraGolemEvent {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState blockState = event.getState();
        Player player = event.getPlayer();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (blockState.is((Block)BlockInit.DEPPSLATE_VIBRANIUM_ORE.get()) && !player.isCreative()) {
            List golems = level.getEntitiesOfClass(VibraGolemEntity.class, player.getBoundingBox().inflate(20.0));
            for (VibraGolemEntity vibraGolem : golems) {
                if (vibraGolem.isTame()) continue;
                vibraGolem.setTarget((LivingEntity)player);
                vibraGolem.setAggressive(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        boolean hasRawVibranium = false;
        if (!player.isCreative()) {
            for (ItemStack itemStack : player.getInventory().items) {
                if (itemStack.getItem() != ItemInit.RAW_VIBRANIUM.get()) continue;
                hasRawVibranium = true;
                break;
            }
            if (hasRawVibranium) {
                List golems = level2.getEntitiesOfClass(VibraGolemEntity.class, player.getBoundingBox().inflate(20.0));
                for (VibraGolemEntity vibraGolem : golems) {
                    if (vibraGolem.isTame()) continue;
                    vibraGolem.setTarget((LivingEntity)player);
                    vibraGolem.setAggressive(true);
                }
            }
        }
    }
}

