/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.event.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.bigbull.vibranium.config.VibraniumConfigValues;
import de.bigbull.vibranium.event.ClientKeyBindings;
import de.bigbull.vibranium.init.ItemInit;
import de.bigbull.vibranium.init.custom.item.VibraniumMaceItem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

@EventBusSubscriber(modid="vibranium", value={Dist.CLIENT})
public class ClientRenderEvent {
    private static boolean isOutlineEnabled = true;

    @SubscribeEvent
    public static void onRenderWorld(RenderHighlightEvent.Block event) {
        HitResult hitResult;
        Minecraft mc = Minecraft.getInstance();
        ItemStack mainHandItem = mc.player.getMainHandItem();
        if (ClientKeyBindings.toggleOutlineKey.consumeClick()) {
            boolean bl = isOutlineEnabled = !isOutlineEnabled;
        }
        if (!isOutlineEnabled) {
            return;
        }
        if (ClientRenderEvent.isValidVibraniumMace(mainHandItem) && (hitResult = mc.hitResult) instanceof BlockHitResult) {
            BlockHitResult hitResult2 = (BlockHitResult)hitResult;
            if (!mc.player.isCreative()) {
                BlockPos hitPos = hitResult2.getBlockPos();
                BlockState blockState = mc.level.getBlockState(hitPos);
                if (!mc.player.isShiftKeyDown() && ClientRenderEvent.isValidBlock(blockState)) {
                    ClientRenderEvent.render3x3Outline(event.getPoseStack(), hitPos);
                    event.setCanceled(true);
                }
            }
        }
    }

    private static boolean isValidVibraniumMace(ItemStack itemStack) {
        return itemStack.getItem() == ItemInit.VIBRANIUM_MACE.get();
    }

    private static boolean isValidBlock(BlockState state) {
        Block block = state.getBlock();
        return !state.isAir() && block.defaultBlockState().isSolidRender((BlockGetter)Minecraft.getInstance().level, BlockPos.ZERO);
    }

    private static void render3x3Outline(PoseStack poseStack, BlockPos center) {
        Minecraft mc = Minecraft.getInstance();
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        poseStack.pushPose();
        poseStack.translate(-camPos.x, -camPos.y, -camPos.z);
        List<BlockPos> positions = VibraniumMaceItem.getBlocksToBeDestroyed(1, center, (Player)mc.player);
        for (BlockPos pos : positions) {
            BlockState state = mc.level.getBlockState(pos);
            if (!ClientRenderEvent.isValidBlock(state)) continue;
            AABB box = state.getShape((BlockGetter)mc.level, pos).bounds().move(pos);
            ClientRenderEvent.renderBlockOutline(poseStack, box);
        }
        poseStack.popPose();
    }

    private static void renderBlockOutline(PoseStack poseStack, AABB boundingBox) {
        RenderType renderType = RenderType.lines();
        VertexConsumer builder = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(renderType);
        float red = (float)VibraniumConfigValues.OUTLINE_RED;
        float green = (float)VibraniumConfigValues.OUTLINE_GREEN;
        float blue = (float)VibraniumConfigValues.OUTLINE_BLUE;
        float alpha = (float)VibraniumConfigValues.OUTLINE_ALPHA;
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)builder, (double)boundingBox.minX, (double)boundingBox.minY, (double)boundingBox.minZ, (double)boundingBox.maxX, (double)boundingBox.maxY, (double)boundingBox.maxZ, (float)red, (float)green, (float)blue, (float)alpha);
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch(renderType);
    }
}

