/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init;

import de.bigbull.vibranium.init.ItemInit;
import de.bigbull.vibranium.init.custom.block.EVDirtBlock;
import de.bigbull.vibranium.init.custom.block.EVFarmlandBlock;
import de.bigbull.vibranium.init.custom.block.HSHBushBlock;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockInit {
    public static DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"vibranium");
    public static final DeferredBlock<Block> BLOCK_OF_RAW_VIBRANIUM = BlockInit.registerBlock("block_of_raw_vibranium", () -> new Block(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_BLUE).requiresCorrectToolForDrops().strength(6.0f, 1200.0f)));
    public static final DeferredBlock<Block> DEPPSLATE_VIBRANIUM_ORE = BlockInit.registerBlock("deepslate_vibranium_ore", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(12.0f, 1200.0f).sound(SoundType.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> Vibranium_Block = BlockInit.registerBlock("vibranium_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).strength(50.0f, 1200.0f).sound(SoundType.NETHERITE_BLOCK).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> HEART_SHAPED_HERB_BUSH = BlockInit.registerBlock("heart_shaped_herb_bush", () -> new HSHBushBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().noCollission().sound(SoundType.SWEET_BERRY_BUSH).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> ENRICHED_VIBRANIUM_DIRT = BlockInit.registerBlock("enriched_vibranium_dirt", () -> new EVDirtBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.8f).sound(SoundType.GRAVEL)));
    public static final DeferredBlock<Block> ENRICHED_VIBRANIUM_FARMLAND = BlockInit.registerBlock("enriched_vibranium_farmland", () -> new EVFarmlandBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).randomTicks().strength(0.6f).sound(SoundType.GRAVEL)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        if (!name.equals("heart_shaped_herb_bush")) {
            ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
    }
}

