/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.item;

import de.bigbull.vibranium.init.EffectInit;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;

public class HSHPotionItem
extends Item {
    private static final int DRINK_DURATION = 32;
    private final int effectDuration;
    private final int effectAmplifier;

    public HSHPotionItem(Item.Properties properties, int effectDuration, int effectAmplifier) {
        super(properties);
        this.effectDuration = effectDuration;
        this.effectAmplifier = effectAmplifier;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!level.isClientSide) {
            level.playSound(null, entity.blockPosition(), SoundEvents.GENERIC_DRINK, entity.getSoundSource(), 1.0f, 1.0f);
            entity.addEffect(new MobEffectInstance(EffectInit.KINETIC_REDISTRIBUTION, this.effectDuration, this.effectAmplifier));
            entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, this.effectDuration, this.effectAmplifier, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, this.effectDuration, this.effectAmplifier, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, this.effectDuration, this.effectAmplifier, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, this.effectDuration, this.effectAmplifier, false, false));
        }
        stack.shrink(1);
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        List<MobEffectInstance> effects = List.of(new MobEffectInstance(EffectInit.KINETIC_REDISTRIBUTION, this.effectDuration, this.effectAmplifier));
        PotionContents.addPotionTooltip(effects, tooltip::add, (float)1.0f, (float)context.tickRate());
    }
}

