/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VibraniumMaceItem
extends DiggerItem {
    private float lastCalculatedDamage = 0.0f;

    public VibraniumMaceItem(Tier tier, TagKey<Block> tag, Item.Properties properties) {
        super(tier, BlockTags.MINEABLE_WITH_PICKAXE, properties);
    }

    public static List<BlockPos> getBlocksToBeDestroyed(int range, BlockPos initalBlockPos, Player player) {
        int y;
        int x;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockHitResult traceResult = player.level().clip(new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(6.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (traceResult.getType() == HitResult.Type.MISS) {
            return positions;
        }
        if (traceResult.getDirection() == Direction.DOWN || traceResult.getDirection() == Direction.UP) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY(), initalBlockPos.getZ() + y));
                }
            }
        }
        if (traceResult.getDirection() == Direction.NORTH || traceResult.getDirection() == Direction.SOUTH) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY() + y, initalBlockPos.getZ()));
                }
            }
        }
        if (traceResult.getDirection() == Direction.EAST || traceResult.getDirection() == Direction.WEST) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX(), initalBlockPos.getY() + y, initalBlockPos.getZ() + x));
                }
            }
        }
        return positions;
    }

    public boolean canAttackBlock(BlockState p_333875_, Level p_333847_, BlockPos p_334073_, Player p_334042_) {
        return !p_334042_.isCreative();
    }

    public boolean hurtEnemy(ItemStack p_334046_, LivingEntity p_333712_, LivingEntity p_333812_) {
        ServerPlayer serverplayer;
        if (p_333812_ instanceof ServerPlayer && VibraniumMaceItem.canSmashAttack((LivingEntity)(serverplayer = (ServerPlayer)p_333812_))) {
            ServerLevel serverlevel = (ServerLevel)p_333812_.level();
            if (serverplayer.isIgnoringFallDamageFromCurrentImpulse() && serverplayer.currentImpulseImpactPos != null) {
                if (serverplayer.currentImpulseImpactPos.y > serverplayer.position().y) {
                    serverplayer.currentImpulseImpactPos = serverplayer.position();
                }
            } else {
                serverplayer.currentImpulseImpactPos = serverplayer.position();
            }
            serverplayer.setIgnoreFallDamageFromCurrentImpulse(true);
            serverplayer.setDeltaMovement(serverplayer.getDeltaMovement().with(Direction.Axis.Y, (double)0.01f));
            serverplayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverplayer));
            if (p_333712_.onGround()) {
                serverplayer.setSpawnExtraParticlesOnFall(true);
                SoundEvent soundevent = serverplayer.fallDistance > 5.0f ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
                serverlevel.playSound(null, serverplayer.getX(), serverplayer.getY(), serverplayer.getZ(), soundevent, serverplayer.getSoundSource(), 1.0f, 1.0f);
            } else {
                serverlevel.playSound(null, serverplayer.getX(), serverplayer.getY(), serverplayer.getZ(), SoundEvents.MACE_SMASH_AIR, serverplayer.getSoundSource(), 1.0f, 1.0f);
            }
            this.knockback((Level)serverlevel, (Player)serverplayer, (Entity)p_333712_);
        }
        return true;
    }

    public void postHurtEnemy(ItemStack p_345716_, LivingEntity p_345817_, LivingEntity p_346003_) {
        p_345716_.hurtAndBreak(1, p_346003_, EquipmentSlot.MAINHAND);
        if (VibraniumMaceItem.canSmashAttack(p_346003_)) {
            p_346003_.resetFallDistance();
        }
    }

    public float getAttackDamageBonus(Entity targetEntity, float baseDamage, DamageSource damageSource) {
        Entity entity = damageSource.getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            if (!VibraniumMaceItem.canSmashAttack(livingentity)) {
                return 0.0f;
            }
            float fallDistance = livingentity.fallDistance;
            float damage = fallDistance <= 3.0f ? 4.0f * fallDistance : (fallDistance <= 8.0f ? 12.0f + 2.0f * (fallDistance - 3.0f) : 22.0f + fallDistance - 8.0f);
            Level level = livingentity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                damage += EnchantmentHelper.modifyFallBasedDamage((ServerLevel)serverlevel, (ItemStack)livingentity.getWeaponItem(), (Entity)targetEntity, (DamageSource)damageSource, (float)0.0f) * fallDistance;
            }
            this.lastCalculatedDamage = damage;
            return damage;
        }
        return 0.0f;
    }

    private void knockback(Level level, Player player, Entity targetEntity) {
        level.levelEvent(2013, targetEntity.getOnPos(), 750);
        level.getEntitiesOfClass(LivingEntity.class, targetEntity.getBoundingBox().inflate(3.5), VibraniumMaceItem.knockbackPredicate(player, targetEntity)).forEach(entity -> {
            Vec3 vec3 = entity.position().subtract(targetEntity.position());
            double knockbackPower = VibraniumMaceItem.getKnockbackPower(player, entity, vec3);
            Vec3 knockbackVec = vec3.normalize().scale(knockbackPower);
            if (knockbackPower > 0.0) {
                entity.push(knockbackVec.x, (double)0.7f, knockbackVec.z);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity;
                    serverplayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverplayer));
                }
                Holder.Reference damageTypeHolder = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.GENERIC);
                DamageSource damageSource = new DamageSource((Holder)damageTypeHolder, (Entity)player);
                float reducedDamage = this.lastCalculatedDamage / 8.0f;
                entity.hurt(damageSource, reducedDamage);
            }
        });
    }

    private static Predicate<LivingEntity> knockbackPredicate(Player player, Entity entity) {
        return p_344407_ -> {
            ArmorStand armorstand;
            TamableAnimal tamableanimal;
            boolean flag = !p_344407_.isSpectator();
            boolean flag1 = p_344407_ != player && p_344407_ != entity;
            boolean flag2 = !player.isAlliedTo((Entity)p_344407_);
            boolean flag6 = p_344407_ instanceof TamableAnimal && (tamableanimal = (TamableAnimal)p_344407_).isTame() && player.getUUID().equals(tamableanimal.getOwnerUUID());
            boolean flag3 = !flag6;
            flag6 = !(p_344407_ instanceof ArmorStand) || !(armorstand = (ArmorStand)p_344407_).isMarker();
            boolean flag4 = flag6;
            boolean flag5 = entity.distanceToSqr((Entity)p_344407_) <= Math.pow(3.5, 2.0);
            return flag && flag1 && flag2 && flag3 && flag4 && flag5;
        };
    }

    private static double getKnockbackPower(Player player, LivingEntity livingEntity, Vec3 vec3) {
        return (3.5 - vec3.length()) * (double)0.7f * (double)(player.fallDistance > 5.0f ? 2 : 1) * (1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(LivingEntity p_344836_) {
        return p_344836_.fallDistance > 1.5f && !p_344836_.isFallFlying();
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        float baseSpeed = this.getTier().getSpeed();
        if (state.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
            return baseSpeed * 0.1005f;
        }
        if (state.is(BlockTags.MINEABLE_WITH_AXE)) {
            return baseSpeed * 0.3f;
        }
        if (state.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return baseSpeed * 0.5f;
        }
        return baseSpeed;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"item.vibranium_mace.tooltip").withStyle(ChatFormatting.GRAY));
    }
}

