/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.item;

import com.google.common.base.Suppliers;
import java.util.EnumMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;

public class WolfArmorItem
extends AnimalArmorItem {
    private static final EnumMap<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> map.put(ArmorItem.Type.BODY, UUID.fromString("C1C72771-8B8E-BA4A-ACE0-81A93C8928B2")));
    private final Supplier<ItemAttributeModifiers> defaultModifiers;
    public final Holder<ArmorMaterial> armorMaterialHolder;
    private final ResourceLocation textureLocation;
    @Nullable
    private final ResourceLocation overlayTextureLocation;

    public WolfArmorItem(Holder<ArmorMaterial> armorMaterial, AnimalArmorItem.BodyType bodyType, boolean pboolean, Item.Properties properties) {
        super(armorMaterial, bodyType, pboolean, properties);
        this.armorMaterialHolder = armorMaterial;
        ResourceLocation resourcelocation = ((ResourceKey)armorMaterial.unwrapKey().orElseThrow()).location().withPath(p -> "textures/entity/wolf/armor/wolf_armor_" + p);
        this.textureLocation = resourcelocation.withSuffix(".png");
        this.overlayTextureLocation = pboolean ? resourcelocation.withSuffix("_overlay.png") : null;
        ResourceLocation resourcelocation2 = ResourceLocation.withDefaultNamespace((String)("armor." + ArmorItem.Type.BODY.getName()));
        this.defaultModifiers = Suppliers.memoize(() -> {
            int i = ((ArmorMaterial)armorMaterial.value()).getDefense(ArmorItem.Type.BODY);
            float f = ((ArmorMaterial)armorMaterial.value()).toughness() * 1.0f;
            ItemAttributeModifiers.Builder itemattributemodifiers$builder = ItemAttributeModifiers.builder();
            EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)ArmorItem.Type.BODY.getSlot());
            UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(ArmorItem.Type.BODY);
            itemattributemodifiers$builder.add(Attributes.ARMOR, new AttributeModifier(resourcelocation2, (double)i, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
            itemattributemodifiers$builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourcelocation2, (double)f, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
            float f1 = ((ArmorMaterial)armorMaterial.value()).knockbackResistance() * 1.0f;
            if (f1 > 0.0f) {
                itemattributemodifiers$builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourcelocation2, (double)f1, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
            }
            return itemattributemodifiers$builder.build();
        });
    }

    public ResourceLocation getTexture() {
        return this.textureLocation;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return this.overlayTextureLocation;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }
}

