/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.item.shield;

import de.bigbull.vibranium.init.ItemInit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="vibranium", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ShieldHandler {
    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Arrow arrow;
        ItemStack activeItem;
        Player player;
        EntityHitResult entityHitResult;
        Entity targetEntity;
        HitResult hitResult = event.getRayTraceResult();
        Projectile projectile = event.getProjectile();
        if (hitResult.getType() == HitResult.Type.ENTITY && (targetEntity = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof Player && (player = (Player)targetEntity).isBlocking() && (activeItem = player.getUseItem()).getItem() == ItemInit.VIBRANIUM_SHIELD.get() && projectile instanceof Arrow && ShieldHandler.isProjectileInFront(player, (Projectile)(arrow = (Arrow)projectile))) {
            event.setCanceled(false);
            ShieldHandler.shootArrowBack(player, arrow);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Entity attacker;
        ItemStack activeItem;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isBlocking() && (activeItem = player.getUseItem()).getItem() == ItemInit.VIBRANIUM_SHIELD.get() && (attacker = event.getSource().getDirectEntity()) instanceof LivingEntity && ShieldHandler.isAttackInFront(player, attacker)) {
            ShieldHandler.knockbackAttacker(player, (LivingEntity)attacker);
            event.getContainer().setNewDamage(0.0f);
        }
    }

    private static boolean isProjectileInFront(Player player, Projectile projectile) {
        Vec3 playerToProjectile = projectile.position().subtract(player.position()).normalize();
        Vec3 playerLookDirection = player.getLookAngle().normalize();
        double dotProduct = playerLookDirection.dot(playerToProjectile);
        return dotProduct > 0.0;
    }

    private static boolean isAttackInFront(Player player, Entity attacker) {
        Vec3 playerToAttacker = attacker.position().subtract(player.position()).normalize();
        Vec3 playerLookDirection = player.getLookAngle().normalize();
        double dotProduct = playerLookDirection.dot(playerToAttacker);
        return dotProduct > 0.0;
    }

    private static void shootArrowBack(Player player, Arrow originalArrow) {
        Player shooter;
        Arrow newArrow = new Arrow(EntityType.ARROW, player.level());
        newArrow.setBaseDamage(originalArrow.getBaseDamage());
        newArrow.setCritArrow(originalArrow.isCritArrow());
        newArrow.setRemainingFireTicks(originalArrow.getRemainingFireTicks());
        newArrow.setOwner((Entity)player);
        newArrow.setPos(originalArrow.getX(), originalArrow.getY(), originalArrow.getZ());
        Vec3 lookDirection = player.getLookAngle();
        Vec3 adjustedDirection = new Vec3(lookDirection.x, lookDirection.y + 0.15, lookDirection.z);
        newArrow.shoot(adjustedDirection.x, adjustedDirection.y, adjustedDirection.z, 1.0f, 1.0f);
        originalArrow.discard();
        Entity owner = originalArrow.getOwner();
        newArrow.pickup = owner instanceof Player ? ((shooter = (Player)owner).getUseItem().getItem() instanceof BowItem ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED) : (owner == null ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.CREATIVE_ONLY);
        player.level().addFreshEntity((Entity)newArrow);
    }

    private static void knockbackAttacker(Player player, LivingEntity attacker) {
        double strength = 1.25;
        Vec3 knockbackDirection = new Vec3(attacker.getX() - player.getX(), 0.0, attacker.getZ() - player.getZ()).normalize();
        attacker.push(knockbackDirection.x * strength, 0.5, knockbackDirection.z * strength);
    }
}

