/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.integration.jei;

import de.bigbull.vibranium.init.BlockInit;
import de.bigbull.vibranium.init.ItemInit;
import de.bigbull.vibranium.init.TagsInit;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

@JeiPlugin
public class JEIPluginVibranium
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)"jei_plugin");

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        registration.addRecipes(RecipeTypes.BREWING, List.of(JEIPluginVibranium.createBrewingRecipe(factory, TagsInit.ItemTagsInit.HEART_SHAPED_HERB_TAG, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.AWKWARD), new ItemStack((ItemLike)ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR.get()), ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)"vibranium_herb_elixir_brewing")), JEIPluginVibranium.createBrewingRecipe(factory, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE, new ItemStack((ItemLike)ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR.get()), new ItemStack((ItemLike)ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR_EXTENDED.get()), ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)"vibranium_extended_brewing")), JEIPluginVibranium.createBrewingRecipe(factory, (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, new ItemStack((ItemLike)ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR.get()), new ItemStack((ItemLike)ItemInit.VIBRANIUM_ENRICHED_HERB_ELIXIR_ENHANCED.get()), ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)"vibranium_enhanced_brewing"))));
        this.addItemDescriptions(registration);
    }

    private static IJeiBrewingRecipe createBrewingRecipe(IVanillaRecipeFactory factory, TagKey<Item> catalystTag, ItemStack inputPotion, ItemStack outputPotion, ResourceLocation uid) {
        ArrayList<ItemStack> catalysts = new ArrayList<ItemStack>();
        for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(catalystTag)) {
            catalysts.add(new ItemStack(item));
        }
        return factory.createBrewingRecipe(catalysts, inputPotion, outputPotion, uid);
    }

    private void addItemDescriptions(IRecipeRegistration registration) {
        registration.addItemStackInfo(new ItemStack((ItemLike)ItemInit.HEART_SHAPED_HERB.get()), new Component[]{Component.translatable((String)"jei.vibranium.heart_shaped_herb.desc")});
        registration.addItemStackInfo(new ItemStack((ItemLike)ItemInit.VIBRANIUM_UPGRADE_SMITHING_TEMPLATE.get()), new Component[]{Component.translatable((String)"jei.vibranium.vibranium_upgrade_smithing_template.desc")});
        registration.addItemStackInfo(new ItemStack((ItemLike)BlockInit.ENRICHED_VIBRANIUM_DIRT.get()), new Component[]{Component.translatable((String)"jei.vibranium.enriched_vibranium_dirt.desc")});
        registration.addItemStackInfo(new ItemStack((ItemLike)ItemInit.VIBRANIUM_CORE.get()), new Component[]{Component.translatable((String)"jei.vibranium.vibranium_core.desc")});
        registration.addItemStackInfo(new ItemStack((ItemLike)BlockInit.ENRICHED_VIBRANIUM_FARMLAND.get()), new Component[]{Component.translatable((String)"jei.vibranium.enriched_vibranium_farmland.desc")});
    }
}

