/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.data;

import de.bigbull.vibranium.Vibranium;
import de.bigbull.vibranium.data.lang.ModDeLangProvider;
import de.bigbull.vibranium.data.lang.ModEnLangProvider;
import de.bigbull.vibranium.data.lang.ModEsLangProvider;
import de.bigbull.vibranium.data.lang.ModFrLangProvider;
import de.bigbull.vibranium.data.loot.ModGlobalLootModifiersProvider;
import de.bigbull.vibranium.data.loottable.ModLootTables;
import de.bigbull.vibranium.data.recipe.ModRecipeProvider;
import de.bigbull.vibranium.data.tag.ModBlockTagsProvider;
import de.bigbull.vibranium.data.tag.ModItemTagsProvider;
import de.bigbull.vibranium.data.texture.ModModelProvider;
import de.bigbull.vibranium.data.worldgen.ModWorldGenProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGenerators {
    public static void gatherDataClient(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        try {
            generator.addProvider(true, (DataProvider)new ModEnLangProvider(output));
            generator.addProvider(true, (DataProvider)new ModDeLangProvider(output));
            generator.addProvider(true, (DataProvider)new ModEsLangProvider(output));
            generator.addProvider(true, (DataProvider)new ModFrLangProvider(output));
            ModBlockTagsProvider modBlockTagsProvider = new ModBlockTagsProvider(output, lookupProvider);
            generator.addProvider(true, (DataProvider)modBlockTagsProvider);
            generator.addProvider(true, (DataProvider)new ModItemTagsProvider(output, lookupProvider, modBlockTagsProvider));
            generator.addProvider(true, (DataProvider)new ModLootTables(output, lookupProvider));
            generator.addProvider(true, (DataProvider)new ModModelProvider(output));
            generator.addProvider(true, (DataProvider)new ModWorldGenProvider(output, lookupProvider));
            generator.addProvider(true, (DataProvider)new ModGlobalLootModifiersProvider(output, lookupProvider));
            generator.addProvider(true, (DataProvider)new ModRecipeProvider.Runner(output, lookupProvider));
        }
        catch (RuntimeException e) {
            Vibranium.logger.error("Failed to generate data", (Throwable)e);
        }
    }
}

