/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.data.recipe;

import com.google.common.collect.ImmutableList;
import de.bigbull.vibranium.init.BlockFamilyInit;
import de.bigbull.vibranium.init.BlockInit;
import de.bigbull.vibranium.init.ItemInit;
import de.bigbull.vibranium.init.TagsInit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModRecipeProvider
extends RecipeProvider {
    public static final ImmutableList<ItemLike> VIBRANIUM_SMELTABLES = ImmutableList.of(ItemInit.RAW_VIBRANIUM, BlockInit.DEPPSLATE_VIBRANIUM_ORE);

    public ModRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
        super(provider, recipeOutput);
    }

    protected void buildRecipes() {
        this.generateBlockFamilies(FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.planksFromLogs((ItemLike)BlockInit.SOULWOOD_PLANKS, (TagKey)TagsInit.Items.SOULWOOD_LOGS, 4);
        this.woodFromLogs((ItemLike)BlockInit.SOULWOOD_WOOD, (ItemLike)BlockInit.SOULWOOD_LOG);
        this.woodenBoat((ItemLike)ItemInit.SOULWOOD_BOAT, (ItemLike)BlockInit.SOULWOOD_PLANKS);
        this.chestBoat((ItemLike)ItemInit.SOULWOOD_CHEST_BOAT, (ItemLike)ItemInit.SOULWOOD_BOAT);
        this.hangingSign((ItemLike)ItemInit.SOULWOOD_HANGING_SIGN, (ItemLike)BlockInit.STRIPPED_SOULWOOD_LOG);
        this.copySmithingTemplate((ItemLike)ItemInit.VIBRANIUM_UPGRADE_SMITHING_TEMPLATE, (ItemLike)ItemInit.VIBRANIUM_INGOT);
        this.shapeless(RecipeCategory.MISC, (ItemLike)ItemInit.RAW_VIBRANIUM, 9).requires(Ingredient.of(BlockInit.BLOCK_OF_RAW_VIBRANIUM), 1).unlockedBy("has_item", this.has((ItemLike)ItemInit.RAW_VIBRANIUM)).save(this.output, "raw_vibranium_from_bock_of_raw_vibranium");
        this.shapeless(RecipeCategory.MISC, (ItemLike)ItemInit.VIBRANIUM_NUGGET, 9).requires(Ingredient.of(ItemInit.VIBRANIUM_INGOT), 1).unlockedBy("has_item", this.has((ItemLike)ItemInit.VIBRANIUM_INGOT)).save(this.output, "vibranium_nugget");
        this.shapeless(RecipeCategory.MISC, (ItemLike)ItemInit.VIBRANIUM_INGOT, 9).requires(Ingredient.of(BlockInit.VIBRANIUM_BLOCK), 1).group("vibranium_ingot").unlockedBy("has_item", this.has((ItemLike)ItemInit.RAW_VIBRANIUM)).save(this.output, "vibranium_ingot_from_vibranium_block");
        this.shapeless(RecipeCategory.MISC, (ItemLike)ItemInit.VIBRANIUM_INGOT, 1).requires(Ingredient.of(ItemInit.VIBRANIUM_NUGGET), 9).group("vibranium_ingot").unlockedBy("has_item", this.has((ItemLike)ItemInit.RAW_VIBRANIUM)).save(this.output, "vibranium_ingot_from_vibranium_nugget");
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockInit.BLOCK_OF_RAW_VIBRANIUM, 1).requires(Ingredient.of(ItemInit.RAW_VIBRANIUM), 9).unlockedBy("has_item", this.has((ItemLike)ItemInit.RAW_VIBRANIUM)).save(this.output, "block_of_raw_vibranium");
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockInit.VIBRANIUM_BLOCK, 1).requires(Ingredient.of(ItemInit.VIBRANIUM_INGOT), 9).unlockedBy("has_item", this.has((ItemLike)ItemInit.VIBRANIUM_INGOT)).save(this.output, "vibranium_block");
        this.shapeless(RecipeCategory.MISC, (ItemLike)ItemInit.VIBRANIUM_INGOT, 1).requires(Ingredient.of(ItemInit.VIBRANIUM_PLATE), 4).requires(Ingredient.of((ItemLike)Items.NETHERITE_SCRAP), 1).requires(Ingredient.of((ItemLike)Items.DIAMOND), 4).group("vibranium_ingot").unlockedBy("has_item", this.has((ItemLike)ItemInit.RAW_VIBRANIUM)).save(this.output, "vibranium_ingot");
        this.shaped(RecipeCategory.MISC, (ItemLike)ItemInit.VIBRANIUM_CORE, 1).pattern(" V ").pattern("VEV").pattern(" V ").define(Character.valueOf('E'), (ItemLike)Items.EMERALD_BLOCK).define(Character.valueOf('V'), ItemInit.VIBRANIUM_INGOT).unlockedBy("has_item", this.has((ItemLike)ItemInit.VIBRANIUM_INGOT)).save(this.output, "vibranium_core");
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ItemInit.VIBRANIUM_MACE, 1).pattern(" C ").pattern("VMV").pattern(" C ").define(Character.valueOf('M'), (ItemLike)Items.MACE).define(Character.valueOf('C'), ItemInit.VIBRANIUM_CORE).define(Character.valueOf('V'), ItemInit.VIBRANIUM_INGOT).unlockedBy("has_item", this.has((ItemLike)ItemInit.VIBRANIUM_INGOT)).save(this.output, "vibranium_mace");
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ItemInit.VIBRANIUM_SHIELD, 1).pattern("WVW").pattern("WHW").pattern(" W ").define(Character.valueOf('H'), ItemInit.VIBRANIUM_CORE).define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('V'), ItemInit.VIBRANIUM_INGOT).unlockedBy("has_item", this.has((ItemLike)ItemInit.VIBRANIUM_INGOT)).save(this.output, "vibranium_shield");
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockInit.VIBRANIUM_CRYSTAL_BLOCK, 1).pattern("##").pattern("##").define(Character.valueOf('#'), ItemInit.VIBRANIUM_CRYSTAL_SHARD).unlockedBy("has_item", this.has((ItemLike)ItemInit.VIBRANIUM_CRYSTAL_SHARD)).save(this.output, "vibranium_crystal_block");
        this.shaped(RecipeCategory.MISC, (ItemLike)ItemInit.SOUL_HERB_MIXTURE, 1).pattern("#F ").pattern("GC ").define(Character.valueOf('#'), ItemInit.HEART_SHAPED_HERB).define(Character.valueOf('F'), (ItemLike)Items.FERMENTED_SPIDER_EYE).define(Character.valueOf('C'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('G'), (ItemLike)Items.GHAST_TEAR).unlockedBy("has_item", this.has((ItemLike)ItemInit.HEART_SHAPED_HERB)).save(this.output, "soul_herb_mixture");
        this.vibraniumSmithing(Items.NETHERITE_SWORD, (Item)ItemInit.VIBRANIUM_SWORD.get());
        this.vibraniumSmithing(Items.NETHERITE_PICKAXE, (Item)ItemInit.VIBRANIUM_PICKAXE.get());
        this.vibraniumSmithing(Items.NETHERITE_AXE, (Item)ItemInit.VIBRANIUM_AXE.get());
        this.vibraniumSmithing(Items.NETHERITE_SHOVEL, (Item)ItemInit.VIBRANIUM_SHOVEL.get());
        this.vibraniumSmithing(Items.NETHERITE_HOE, (Item)ItemInit.VIBRANIUM_HOE.get());
        this.vibraniumSmithing(Items.NETHERITE_HELMET, (Item)ItemInit.VIBRANIUM_HELMET.get());
        this.vibraniumSmithing(Items.TURTLE_HELMET, (Item)ItemInit.VIBRANIUM_TURTLE_HELMET.get());
        this.vibraniumSmithing(Items.NETHERITE_CHESTPLATE, (Item)ItemInit.VIBRANIUM_CHESTPLATE.get());
        this.vibraniumSmithing(Items.NETHERITE_LEGGINGS, (Item)ItemInit.VIBRANIUM_LEGGINGS.get());
        this.vibraniumSmithing(Items.NETHERITE_BOOTS, (Item)ItemInit.VIBRANIUM_BOOTS.get());
        this.vibraniumSmithing(Items.WOLF_ARMOR, (Item)ItemInit.VIBRANIUM_WOLF_ARMOR.get());
        this.vibraniumSmithing(Items.DIAMOND_HORSE_ARMOR, (Item)ItemInit.VIBRANIUM_HORSE_ARMOR.get());
        this.oreSmelting((List)VIBRANIUM_SMELTABLES, RecipeCategory.MISC, (ItemLike)ItemInit.VIBRANIUM_PLATE, 2.5f, 400, "vibranium_ingot");
        this.oreBlasting((List)VIBRANIUM_SMELTABLES, RecipeCategory.MISC, (ItemLike)ItemInit.VIBRANIUM_PLATE, 2.5f, 150, "vibranium_ingot");
    }

    protected void generateBlockFamilies(FeatureFlagSet flags) {
        BlockFamilyInit.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(family -> this.generateRecipes((BlockFamily)family, flags));
    }

    protected void vibraniumSmithing(Item item, Item outputItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of(ItemInit.VIBRANIUM_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)item), (Ingredient)this.tag(TagsInit.Items.VIBRANIUM_TOOL_MATERIALS), (RecipeCategory)RecipeCategory.TOOLS, (Item)outputItem).unlocks("has_vibranium_ingot", this.has(TagsInit.Items.VIBRANIUM_TOOL_MATERIALS)).save(this.output, ModRecipeProvider.getItemName((ItemLike)outputItem) + "_smithing");
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
            super(packOutput, completableFuture);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            return new ModRecipeProvider(provider, recipeOutput);
        }

        public String getName() {
            return "Vibranium Recipes";
        }
    }
}

