/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.data.worldgen;

import de.bigbull.vibranium.init.BlockInit;
import de.bigbull.vibranium.init.FeatureInit;
import de.bigbull.vibranium.init.custom.SoulTreeTrunkPlacer;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    protected static ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_VIBRANIUM_ORE = ModConfiguredFeatures.createKey("overworld_vibranium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SOUL_TREE = ModConfiguredFeatures.createKey("soul_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SOUL_TREE_SMALL = ModConfiguredFeatures.createKey("soul_tree_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SOUL_TREE_MINI = ModConfiguredFeatures.createKey("soul_tree_mini");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VIBRANIUM_GEODE = ModConfiguredFeatures.createKey("vibranium_geode");

    public static TreeConfiguration.TreeConfigurationBuilder soulTree() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)BlockInit.SOULWOOD_LOG.get()).defaultBlockState()), (TrunkPlacer)new SoulTreeTrunkPlacer(6, 4, 1, (IntProvider)new WeightedListInt(WeightedList.builder().add((Object)ConstantInt.of((int)1), 1).add((Object)ConstantInt.of((int)2), 1).add((Object)ConstantInt.of((int)3), 1).add((Object)ConstantInt.of((int)4), 1).build()), (IntProvider)UniformInt.of((int)2, (int)5), (IntProvider)UniformInt.of((int)-4, (int)-1), (IntProvider)UniformInt.of((int)-2, (int)2)), (BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)BlockInit.SOULWOOD_LEAVES.get()).defaultBlockState()), (FoliagePlacer)new CherryFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)5), 0.25f, 0.5f, 0.16666667f, 0.33333334f), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).ignoreVines();
    }

    public static TreeConfiguration.TreeConfigurationBuilder soulTreeSmall() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.SOULWOOD_LOG.get())), (TrunkPlacer)new ForkingTrunkPlacer(5, 2, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.SOULWOOD_LEAVES.get())), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).ignoreVines();
    }

    public static TreeConfiguration.TreeConfigurationBuilder soulTreeMini() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.SOULWOOD_LOG.get())), (TrunkPlacer)new ForkingTrunkPlacer(3, 1, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.SOULWOOD_LEAVES.get())), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines();
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplacable = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplacable = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> VibraniumOre = List.of(OreConfiguration.target((RuleTest)stoneReplacable, (BlockState)((Block)BlockInit.DEPPSLATE_VIBRANIUM_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplacable, (BlockState)((Block)BlockInit.DEPPSLATE_VIBRANIUM_ORE.get()).defaultBlockState()));
        FeatureUtils.register(context, OVERWORLD_VIBRANIUM_ORE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(VibraniumOre, 4));
        FeatureUtils.register(context, VIBRANIUM_GEODE, FeatureInit.VIBRANIUM_GEODE.get(), (FeatureConfiguration)new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.AIR), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.VIBRANIUM_CRYSTAL_BLOCK.get())), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.BUDDING_VIBRANIUM_CRYSTAL.get())), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.CALCITE), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SMOOTH_BASALT), List.of(((Block)BlockInit.SMALL_VIBRANIUM_BUD.get()).defaultBlockState(), ((Block)BlockInit.MEDIUM_VIBRANIUM_BUD.get()).defaultBlockState(), ((Block)BlockInit.LARGE_VIBRANIUM_BUD.get()).defaultBlockState(), ((Block)BlockInit.VIBRANIUM_CLUSTER.get()).defaultBlockState()), BlockTags.FEATURES_CANNOT_REPLACE, BlockTags.GEODE_INVALID_BLOCKS), new GeodeLayerSettings(1.7, 2.2, 3.2, 4.2), new GeodeCrackSettings(0.5, 2.0, 2), 0.35, 0.083, true, (IntProvider)UniformInt.of((int)5, (int)6), (IntProvider)UniformInt.of((int)4, (int)5), (IntProvider)UniformInt.of((int)1, (int)4), -16, 16, 0.05, 1));
        FeatureUtils.register(context, SOUL_TREE, (Feature)((Feature)FeatureInit.SOUL_TREE.get()), (FeatureConfiguration)ModConfiguredFeatures.soulTree().build());
        FeatureUtils.register(context, SOUL_TREE_SMALL, (Feature)((Feature)FeatureInit.SOUL_TREE_SMALL.get()), (FeatureConfiguration)ModConfiguredFeatures.soulTreeSmall().build());
        FeatureUtils.register(context, SOUL_TREE_MINI, FeatureInit.SOUL_TREE_MINI.get(), (FeatureConfiguration)ModConfiguredFeatures.soulTreeMini().build());
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)name));
    }
}

