/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.data.worldgen;

import de.bigbull.vibranium.data.worldgen.ModConfiguredFeatures;
import de.bigbull.vibranium.data.worldgen.ore.ModOrePlacement;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static ResourceKey<PlacedFeature> VIBRANIUM_ORE = ModPlacedFeatures.createKey("vibranium_ore");
    public static ResourceKey<PlacedFeature> VIBRANIUM_GEODE = ModPlacedFeatures.createKey("vibranium_geode");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference vibraniumOreFeature = configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_VIBRANIUM_ORE);
        Holder.Reference vibraniumGeodeFeature = configuredFeatures.getOrThrow(ModConfiguredFeatures.VIBRANIUM_GEODE);
        PlacementUtils.register(context, VIBRANIUM_ORE, (Holder)vibraniumOreFeature, ModOrePlacement.commonOrePlacements(3, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)-10))));
        PlacementUtils.register(context, VIBRANIUM_GEODE, (Holder)vibraniumGeodeFeature, List.of(RarityFilter.onAverageOnceEvery((int)50), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-45), (VerticalAnchor)VerticalAnchor.absolute((int)15)), BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)name));
    }
}

