/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.data.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import de.bigbull.vibranium.data.worldgen.ModConfiguredFeatures;
import de.bigbull.vibranium.init.BlockInit;
import de.bigbull.vibranium.init.custom.block.EVDirtBlock;
import de.bigbull.vibranium.init.custom.block.HSHBushBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;

public class VibraniumGeodeFeature
extends Feature<GeodeConfiguration> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public VibraniumGeodeFeature(Codec<GeodeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<GeodeConfiguration> context) {
        GeodeConfiguration geodeconfiguration = (GeodeConfiguration)context.config();
        RandomSource randomsource = context.random();
        BlockPos blockpos = context.origin();
        WorldGenLevel worldgenlevel = context.level();
        int i = geodeconfiguration.minGenOffset;
        int j = geodeconfiguration.maxGenOffset;
        LinkedList list = Lists.newLinkedList();
        int k = geodeconfiguration.distributionPoints.sample(randomsource);
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(worldgenlevel.getSeed()));
        NormalNoise normalnoise = NormalNoise.create((RandomSource)worldgenrandom, (int)-4, (double[])new double[]{1.0});
        LinkedList list1 = Lists.newLinkedList();
        double d0 = (double)k / (double)geodeconfiguration.outerWallDistance.getMaxValue();
        GeodeLayerSettings geodelayersettings = geodeconfiguration.geodeLayerSettings;
        GeodeBlockSettings geodeblocksettings = geodeconfiguration.geodeBlockSettings;
        GeodeCrackSettings geodecracksettings = geodeconfiguration.geodeCrackSettings;
        double d1 = 1.0 / Math.sqrt(geodelayersettings.filling);
        double d2 = 1.0 / Math.sqrt(geodelayersettings.innerLayer + d0);
        double d3 = 1.0 / Math.sqrt(geodelayersettings.middleLayer + d0);
        double d4 = 1.0 / Math.sqrt(geodelayersettings.outerLayer + d0);
        double d5 = 1.0 / Math.sqrt(geodecracksettings.baseCrackSize + randomsource.nextDouble() / 2.0 + (k > 3 ? d0 : 0.0));
        boolean flag = (double)randomsource.nextFloat() < geodecracksettings.generateCrackChance;
        int l = 0;
        HashMap<Integer, List> innerLayerPositionsByY = new HashMap<Integer, List>();
        int lowestY = Integer.MAX_VALUE;
        for (int i1 = 0; i1 < k; ++i1) {
            int l1;
            int k1;
            int j1 = geodeconfiguration.outerWallDistance.sample(randomsource);
            BlockPos blockpos1 = blockpos.offset(j1, k1 = geodeconfiguration.outerWallDistance.sample(randomsource), l1 = geodeconfiguration.outerWallDistance.sample(randomsource));
            BlockState blockstate = worldgenlevel.getBlockState(blockpos1);
            if ((blockstate.isAir() || blockstate.is(BlockTags.GEODE_INVALID_BLOCKS)) && ++l > geodeconfiguration.invalidBlocksThreshold) {
                return false;
            }
            list.add(Pair.of((Object)blockpos1, (Object)geodeconfiguration.pointOffset.sample(randomsource)));
        }
        if (flag) {
            int i2 = randomsource.nextInt(4);
            int j2 = k * 2 + 1;
            if (i2 == 0) {
                list1.add(blockpos.offset(j2, 7, 0));
                list1.add(blockpos.offset(j2, 5, 0));
                list1.add(blockpos.offset(j2, 1, 0));
            } else if (i2 == 1) {
                list1.add(blockpos.offset(0, 7, j2));
                list1.add(blockpos.offset(0, 5, j2));
                list1.add(blockpos.offset(0, 1, j2));
            } else if (i2 == 2) {
                list1.add(blockpos.offset(j2, 7, j2));
                list1.add(blockpos.offset(j2, 5, j2));
                list1.add(blockpos.offset(j2, 1, j2));
            } else {
                list1.add(blockpos.offset(0, 7, 0));
                list1.add(blockpos.offset(0, 5, 0));
                list1.add(blockpos.offset(0, 1, 0));
            }
        }
        ArrayList list2 = Lists.newArrayList();
        Predicate predicate = VibraniumGeodeFeature.isReplaceable((TagKey)geodeconfiguration.geodeBlockSettings.cannotReplace);
        for (BlockPos blockpos3 : BlockPos.betweenClosed((BlockPos)blockpos.offset(i, i, i), (BlockPos)blockpos.offset(j, j, j))) {
            double d8 = normalnoise.getValue((double)blockpos3.getX(), (double)blockpos3.getY(), (double)blockpos3.getZ()) * geodeconfiguration.noiseMultiplier;
            double d6 = 0.0;
            double d7 = 0.0;
            for (Pair pair : list) {
                d6 += Mth.invSqrt((double)(blockpos3.distSqr((Vec3i)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + d8;
            }
            for (BlockPos blockpos6 : list1) {
                d7 += Mth.invSqrt((double)(blockpos3.distSqr((Vec3i)blockpos6) + (double)geodecracksettings.crackPointOffset)) + d8;
            }
            if (d6 < d4) continue;
            if (flag && d7 >= d5 && d6 < d1) {
                this.safeSetBlock(worldgenlevel, blockpos3, Blocks.AIR.defaultBlockState(), predicate);
                for (Direction direction1 : DIRECTIONS) {
                    BlockPos blockpos2 = blockpos3.relative(direction1);
                    FluidState fluidstate = worldgenlevel.getFluidState(blockpos2);
                    if (fluidstate.isEmpty()) continue;
                    worldgenlevel.scheduleTick(blockpos2, fluidstate.getType(), 0);
                }
                continue;
            }
            if (d6 >= d1) {
                this.safeSetBlock(worldgenlevel, blockpos3, geodeblocksettings.fillingProvider.getState(randomsource, blockpos3), predicate);
                continue;
            }
            if (d6 >= d2) {
                BlockState innerLayerState;
                boolean flag1 = (double)randomsource.nextFloat() < geodeconfiguration.useAlternateLayer0Chance;
                BlockState blockState = innerLayerState = flag1 ? geodeblocksettings.alternateInnerLayerProvider.getState(randomsource, blockpos3) : geodeblocksettings.innerLayerProvider.getState(randomsource, blockpos3);
                if (innerLayerState.is((Block)BlockInit.VIBRANIUM_CRYSTAL_BLOCK.get())) {
                    int y = blockpos3.getY();
                    innerLayerPositionsByY.computeIfAbsent(y, k2 -> new ArrayList()).add(blockpos3.immutable());
                    lowestY = Math.min(lowestY, y);
                }
                this.safeSetBlock(worldgenlevel, blockpos3, innerLayerState, predicate);
                if (geodeconfiguration.placementsRequireLayer0Alternate && !flag1 || !((double)randomsource.nextFloat() < geodeconfiguration.usePotentialPlacementsChance)) continue;
                list2.add(blockpos3.immutable());
                continue;
            }
            if (d6 >= d3) {
                this.safeSetBlock(worldgenlevel, blockpos3, geodeblocksettings.middleLayerProvider.getState(randomsource, blockpos3), predicate);
                continue;
            }
            if (!(d6 >= d4)) continue;
            this.safeSetBlock(worldgenlevel, blockpos3, geodeblocksettings.outerLayerProvider.getState(randomsource, blockpos3), predicate);
        }
        List list3 = geodeblocksettings.innerPlacements;
        block5: for (BlockPos blockpos4 : list2) {
            BlockState blockstate1 = (BlockState)Util.getRandom((List)list3, (RandomSource)randomsource);
            for (Direction direction : DIRECTIONS) {
                if (blockstate1.hasProperty((Property)BlockStateProperties.FACING)) {
                    blockstate1 = (BlockState)blockstate1.setValue((Property)BlockStateProperties.FACING, (Comparable)direction);
                }
                BlockPos blockpos5 = blockpos4.relative(direction);
                BlockState blockstate2 = worldgenlevel.getBlockState(blockpos5);
                if (blockstate1.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    blockstate1 = (BlockState)blockstate1.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate2.getFluidState().isSource()));
                }
                if (!BuddingAmethystBlock.canClusterGrowAtState((BlockState)blockstate2)) continue;
                this.safeSetBlock(worldgenlevel, blockpos5, blockstate1, predicate);
                continue block5;
            }
        }
        ArrayList<BlockPos> enrichedDirtPositions = new ArrayList<BlockPos>();
        if (lowestY != Integer.MAX_VALUE) {
            BlockPos abovePos;
            int y;
            Integer airExposedLevel = null;
            block7: for (y = lowestY; y < lowestY + 10 && airExposedLevel == null; ++y) {
                List positions = (List)innerLayerPositionsByY.get(y);
                if (positions == null) continue;
                for (BlockPos pos : positions) {
                    abovePos = pos.above();
                    if (!worldgenlevel.isEmptyBlock(abovePos)) continue;
                    airExposedLevel = y;
                    continue block7;
                }
            }
            if (airExposedLevel != null) {
                for (y = airExposedLevel.intValue(); y <= airExposedLevel + 2; ++y) {
                    List positions = (List)innerLayerPositionsByY.get(y);
                    if (positions == null) continue;
                    for (BlockPos pos : positions) {
                        abovePos = pos.above();
                        if (!worldgenlevel.isEmptyBlock(abovePos) || !(randomsource.nextFloat() < 0.3f)) continue;
                        this.safeSetBlock(worldgenlevel, pos, ((EVDirtBlock)((Object)BlockInit.ENRICHED_VIBRANIUM_DIRT.get())).defaultBlockState(), predicate);
                        enrichedDirtPositions.add(pos.immutable());
                    }
                }
            }
        }
        this.placeVegetation(worldgenlevel, enrichedDirtPositions, randomsource, context);
        return true;
    }

    private void placeVegetation(WorldGenLevel world, List<BlockPos> enrichedDirtPositions, RandomSource random, FeaturePlaceContext<GeodeConfiguration> context) {
        if (enrichedDirtPositions.isEmpty()) {
            return;
        }
        Collections.shuffle(enrichedDirtPositions, new Random(random.nextLong()));
        for (BlockPos dirtPos : enrichedDirtPositions) {
            BlockPos above = dirtPos.above();
            if (!world.isEmptyBlock(above)) continue;
            if (random.nextFloat() < 0.35f && this.hasEnoughSpaceForTree(world, above)) {
                this.placeSoulTree(world, above, random, context);
                continue;
            }
            if (random.nextFloat() < 0.45f) {
                world.setBlock(above, (BlockState)((Block)BlockInit.HEART_SHAPED_HERB_BUSH.get()).defaultBlockState().setValue((Property)HSHBushBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(4))), 2);
                continue;
            }
            if (!(random.nextFloat() < 0.1f)) continue;
            world.setBlock(above, ((Block)BlockInit.SOULWOOD_SAPLING.get()).defaultBlockState(), 2);
        }
    }

    private boolean hasEnoughSpaceForTree(WorldGenLevel world, BlockPos pos) {
        for (int y = 0; y < 4; ++y) {
            if (world.isEmptyBlock(pos.above(y))) continue;
            return false;
        }
        return true;
    }

    private void placeSoulTree(WorldGenLevel worldgenlevel, BlockPos soulTreePos, RandomSource random, FeaturePlaceContext<GeodeConfiguration> context) {
        BlockState before = worldgenlevel.getBlockState(soulTreePos);
        TreeConfiguration soulTreeConfig = random.nextFloat() < 0.25f ? ModConfiguredFeatures.soulTree().build() : ModConfiguredFeatures.soulTreeSmall().build();
        Feature.TREE.place(new FeaturePlaceContext(Optional.empty(), worldgenlevel, context.chunkGenerator(), random, soulTreePos, (FeatureConfiguration)soulTreeConfig));
        BlockState after = worldgenlevel.getBlockState(soulTreePos);
        if (before != after && !after.isAir()) {
            return;
        }
        if (random.nextFloat() < 0.2f) {
            TreeConfiguration miniConfig = ModConfiguredFeatures.soulTreeMini().build();
            Feature.TREE.place(new FeaturePlaceContext(Optional.empty(), worldgenlevel, context.chunkGenerator(), random, soulTreePos, (FeatureConfiguration)miniConfig));
        } else if (random.nextFloat() < 0.3f) {
            worldgenlevel.setBlock(soulTreePos, (BlockState)((Block)BlockInit.HEART_SHAPED_HERB_BUSH.get()).defaultBlockState().setValue((Property)HSHBushBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(2))), 2);
        } else if (random.nextFloat() < 0.1f) {
            worldgenlevel.setBlock(soulTreePos, ((Block)BlockInit.SOULWOOD_SAPLING.get()).defaultBlockState(), 2);
        }
    }
}

