/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.entity;

import de.bigbull.vibranium.entity.ai.DefensiveGoal;
import de.bigbull.vibranium.entity.ai.PushGoal;
import de.bigbull.vibranium.entity.ai.RegenerationGoal;
import de.bigbull.vibranium.entity.ai.VibraGolemAttackGoal;
import de.bigbull.vibranium.entity.client.Crackniess.VibraCrackiness;
import de.bigbull.vibranium.init.ItemInit;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class VibraGolemEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(VibraGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(VibraGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DEFENSIVE_MODE = SynchedEntityData.defineId(VibraGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<BlockPos> DEFENSIVE_POSITION = SynchedEntityData.defineId(VibraGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private UUID ownerUUID;
    private DamageSource lastDamageSource;
    private boolean isRaging = false;
    private int particlecounter = 10;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public int attackAnimationTimeout = 0;

    public VibraGolemEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.ATTACK_DAMAGE, 15.0).add(Attributes.ATTACK_SPEED, 0.4).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 0.4).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new VibraGolemAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                return super.canUse() && !VibraGolemEntity.this.isDefensiveMode();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new DefensiveGoal(this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.goalSelector.addGoal(7, (Goal)new PushGoal(this));
        this.goalSelector.addGoal(5, (Goal)new RegenerationGoal(this));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationState();
        }
    }

    private void setupAnimationState() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 10;
            this.attackAnimationState.start(this.tickCount);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.stop();
        }
    }

    protected void updateWalkAnimation(float particalTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(particalTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACKING, (Object)false);
        builder.define(SITTING, (Object)false);
        builder.define(DEFENSIVE_MODE, (Object)false);
        builder.define(DEFENSIVE_POSITION, (Object)BlockPos.ZERO);
    }

    public boolean doHurtTarget(ServerLevel level, Entity entity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        float damage = this.getAttackDamage();
        float actualDamage = (int)damage > 0 ? damage / 2.0f + (float)this.random.nextInt((int)damage) : damage;
        DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
        boolean success = entity.hurtServer(level, damageSource, actualDamage);
        if (success) {
            double d;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                d = livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            } else {
                d = 0.0;
            }
            double knockbackResistance = d;
            double knockback = Math.max(0.0, 1.0 - knockbackResistance);
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)0.4f * knockback, 0.0));
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        }
        return success;
    }

    public boolean hurtServer(ServerLevel p_376593_, DamageSource p_376434_, float p_376366_) {
        VibraCrackiness.Level crackiness$level = this.getCrackiness();
        boolean flag = super.hurtServer(p_376593_, p_376434_, p_376366_);
        if (flag && this.getCrackiness() != crackiness$level) {
            this.playSound(SoundEvents.IRON_GOLEM_DAMAGE, 1.0f, 1.0f);
        }
        return flag;
    }

    public void aiStep() {
        super.aiStep();
        if (this.isDefensiveMode()) {
            ++this.particlecounter;
            if (this.particlecounter > 10 && this.level().isClientSide()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY() + 4.0, this.getZ(), 0.0, 0.0, 0.0);
                this.particlecounter = 0;
            }
        } else {
            this.particlecounter = 10;
        }
    }

    public boolean canSpawnSprintParticle() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0;
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        } else if (id == 5) {
            this.isRaging = true;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        Item TamingItem = (Item)ItemInit.VIBRANIUM_CORE.get();
        Item HealingItem = (Item)ItemInit.VIBRANIUM_INGOT.get();
        if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)player) && !this.level().isClientSide() && hand == InteractionHand.MAIN_HAND) {
                if (item == HealingItem && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(player, hand, itemstack);
                    itemstack.consume(1, (LivingEntity)player);
                    this.heal(25.0f);
                } else {
                    if (player.isShiftKeyDown()) {
                        this.setDefensiveMode(!this.isDefensiveMode(), this.blockPosition());
                        return InteractionResult.SUCCESS;
                    }
                    InteractionResult interactionresult = super.mobInteract(player, hand);
                    if (!interactionresult.consumesAction()) {
                        this.setSitting(!this.isSitting());
                        this.jumping = false;
                        this.navigation.stop();
                        this.setTarget(null);
                        return InteractionResult.TRY_WITH_EMPTY_HAND;
                    }
                    return interactionresult;
                }
            }
            return super.mobInteract(player, hand);
        }
        if (item == TamingItem) {
            if (!this.level().isClientSide()) {
                itemstack.consume(1, (LivingEntity)player);
                this.usePlayerItem(player, hand, itemstack);
                this.tryToTame(player);
                return InteractionResult.SUCCESS;
            }
            return super.mobInteract(player, hand);
        }
        return super.mobInteract(player, hand);
    }

    private void tryToTame(Player player) {
        if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
            this.tame(player);
            this.navigation.stop();
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack itemStack) {
        if (itemStack.getItem() == ItemInit.VIBRANIUM_INGOT.get()) {
            this.playSound(SoundEvents.NETHERITE_BLOCK_HIT, 1.0f, 1.0f);
        }
        if (itemStack.getItem() == ItemInit.VIBRANIUM_CORE.get()) {
            this.playSound((SoundEvent)SoundEvents.GENERIC_EAT.value(), 1.0f, 1.0f);
        }
        super.usePlayerItem(player, hand, itemStack);
    }

    public boolean wantsToAttack(LivingEntity entity, LivingEntity entity1) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (entity instanceof Creeper || entity instanceof Ghast || entity instanceof ArmorStand) {
            return false;
        }
        if (entity instanceof VibraGolemEntity) {
            VibraGolemEntity vibraGolem = (VibraGolemEntity)entity;
            return !vibraGolem.isTame() || vibraGolem.getOwner() != entity1;
        }
        if (entity instanceof Player) {
            Player player1;
            Player player = (Player)entity;
            if (entity1 instanceof Player && !(player1 = (Player)entity1).canHarmPlayer(player)) {
                return false;
            }
        }
        if (entity instanceof AbstractHorse && (abstracthorse = (AbstractHorse)entity).isTamed()) {
            return false;
        }
        return !(entity instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)entity).isTame();
    }

    public boolean isDefensiveMode() {
        return (Boolean)this.entityData.get(DEFENSIVE_MODE);
    }

    public void setDefensiveMode(boolean defensiveMode, BlockPos position) {
        this.entityData.set(DEFENSIVE_MODE, (Object)defensiveMode);
        this.entityData.set(DEFENSIVE_POSITION, (Object)position);
    }

    public BlockPos getDefensivePosition() {
        return (BlockPos)this.entityData.get(DEFENSIVE_POSITION);
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
        this.setOrderedToSit(sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public DamageSource getLastDamageSource() {
        return this.lastDamageSource;
    }

    public VibraCrackiness.Level getCrackiness() {
        return VibraCrackiness.VIBRA_GOLEM.byFraction(this.getHealth() / this.getMaxHealth());
    }

    private float getAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.HOSTILE_SWIM;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WARDEN_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(SoundEvents.IRON_GOLEM_STEP, 0.15f, 1.0f);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public void tryToTeleportToOwner() {
    }

    public void startRage() {
        this.isRaging = true;
        this.level().broadcastEntityEvent((Entity)this, (byte)5);
    }
}

