/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.entity.ai;

import de.bigbull.vibranium.entity.VibraGolemEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.phys.AABB;

public class DefensiveGoal
extends Goal {
    private final VibraGolemEntity entity;
    private BlockPos defensivePosition;

    public DefensiveGoal(VibraGolemEntity entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        return this.entity.isDefensiveMode() && this.entity.getDefensivePosition() != null;
    }

    public void start() {
        this.defensivePosition = this.entity.getDefensivePosition();
    }

    public void stop() {
        this.entity.setTarget(null);
        this.entity.getNavigation().stop();
    }

    public void tick() {
        if (!this.entity.isDefensiveMode()) {
            return;
        }
        List monsters = this.entity.level().getEntitiesOfClass(Monster.class, new AABB(this.defensivePosition).inflate(40.0));
        if (!monsters.isEmpty()) {
            for (Monster monster : monsters) {
                if (!this.entity.hasLineOfSight((Entity)monster) || monster.isUnderWater()) continue;
                this.entity.getNavigation().moveTo((Entity)monster, 1.0);
                this.entity.setTarget((LivingEntity)monster);
                return;
            }
        } else if (this.entity.distanceToSqr(this.defensivePosition.getX(), this.defensivePosition.getY(), this.defensivePosition.getZ()) > 1.0) {
            this.entity.getNavigation().moveTo((double)this.defensivePosition.getX(), (double)this.defensivePosition.getY(), (double)this.defensivePosition.getZ(), 1.0);
        } else {
            this.entity.setTarget(null);
            this.entity.getNavigation().stop();
        }
    }

    public boolean canContinueToUse() {
        return this.entity.isDefensiveMode() && this.entity.getDefensivePosition() != null;
    }
}

