/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.entity.ai;

import de.bigbull.vibranium.entity.VibraGolemEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class VibraGolemAttackGoal
extends MeleeAttackGoal {
    private final VibraGolemEntity entity;
    private int attackDelay = 4;
    private int ticksUntilNextAttack = 6;
    private boolean shouldCountTillNextAttack = false;

    public VibraGolemAttackGoal(PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super(mob, speedModifier, followingTargetEvenIfNotSeen);
        this.entity = (VibraGolemEntity)mob;
    }

    public void start() {
        super.start();
        this.attackDelay = 4;
        this.ticksUntilNextAttack = 6;
    }

    public void tick() {
        super.tick();
        LivingEntity target = this.mob.getTarget();
        if (target != null) {
            double distanceToTarget = this.mob.distanceToSqr((Entity)target);
            if (this.isEnemyWithinAttackDistance(target, distanceToTarget)) {
                this.shouldCountTillNextAttack = true;
                if (this.isTimeToStartAttackAnimation()) {
                    this.entity.setAttacking(true);
                }
                if (this.isTimeToAttack()) {
                    this.mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
                    this.performAttack(target);
                }
            } else {
                this.resetAttackCooldown();
                this.shouldCountTillNextAttack = false;
                this.entity.setAttacking(false);
                this.entity.attackAnimationTimeout = 0;
            }
        }
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= this.getAttackReachSqr(pEnemy);
    }

    protected double getAttackReachSqr(LivingEntity enemy) {
        return this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + enemy.getBbWidth();
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(this.attackDelay * 2);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.resetAttackCooldown();
        this.mob.swing(InteractionHand.MAIN_HAND);
        this.mob.doHurtTarget((ServerLevel)this.mob.level(), (Entity)pEnemy);
    }

    public void stop() {
        this.entity.setAttacking(false);
        super.stop();
    }
}

