/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.entity.client;

import de.bigbull.vibranium.entity.client.VibraGolemRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class VibraGolemModel
extends EntityModel<VibraGolemRenderState> {
    private final ModelPart head;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public VibraGolemModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.rightArm = root.getChild("R_Arm");
        this.leftArm = root.getChild("L_Arm");
        this.rightLeg = root.getChild("R_Leg");
        this.leftLeg = root.getChild("L_Leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-14.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).addBox(-8.0f, -12.0f, -6.0f, 16.0f, 12.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-28.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("R_Arm", CubeListBuilder.create().texOffs(50, 36).addBox(-9.0f, -4.0f, -6.0f, 9.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-13.0f, (float)-24.0f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)0.0436f));
        partdefinition.addOrReplaceChild("R_LowerArm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)14.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(66, 12).addBox(-8.0f, -6.0f, -4.0f, 9.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("L_Arm", CubeListBuilder.create().texOffs(48, 57).addBox(0.0f, -4.0f, -6.0f, 9.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)-24.0f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)-0.0436f));
        partdefinition.addOrReplaceChild("L_LowerArm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.0f, (float)14.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("L_Leg", CubeListBuilder.create().texOffs(96, 69).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(84, 98).addBox(-3.0f, 3.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-14.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("L_LowerLeg", CubeListBuilder.create().texOffs(84, 49).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("R_Leg", CubeListBuilder.create().texOffs(94, 2).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(60, 98).addBox(-3.0f, 3.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-14.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("R_LowerLeg", CubeListBuilder.create().texOffs(72, 78).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(VibraGolemRenderState state) {
        super.setupAnim((Object)state);
        float f = state.attackTicksRemaining;
        float f1 = state.walkAnimationSpeed;
        float f2 = state.walkAnimationPos;
        if (f > 0.0f) {
            this.rightArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)f, (float)10.0f);
            this.leftArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)f, (float)10.0f);
        } else {
            this.rightArm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)f2, (float)13.0f)) * f1;
            this.leftArm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)f2, (float)13.0f)) * f1;
        }
        this.head.yRot = state.yRot * ((float)Math.PI / 180);
        this.head.xRot = state.xRot * ((float)Math.PI / 180);
        this.rightLeg.xRot = -1.5f * Mth.triangleWave((float)f2, (float)13.0f) * f1;
        this.leftLeg.xRot = 1.5f * Mth.triangleWave((float)f2, (float)13.0f) * f1;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch, float ageInTicks) {
        netHeadYaw = Mth.clamp((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }
}

