/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.event;

import de.bigbull.vibranium.config.ServerConfig;
import de.bigbull.vibranium.entity.VibraGolemEntity;
import de.bigbull.vibranium.init.BlockInit;
import de.bigbull.vibranium.init.EnchantmentInit;
import de.bigbull.vibranium.init.ItemInit;
import de.bigbull.vibranium.init.custom.block.EVDirtBlock;
import de.bigbull.vibranium.init.custom.item.VibraniumMaceItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="vibranium")
public class ModGameEvents {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    @SubscribeEvent
    public static void onHammerUsage(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getMainHandItem();
        Level level = event.getPlayer().level();
        BlockState middleBlockState = event.getLevel().getBlockState(event.getPos());
        if (mainHandItem.getItem() instanceof VibraniumMaceItem && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!player.isShiftKeyDown()) {
                BlockPos initialBlockPos = event.getPos();
                TagKey<Block> requiredTool = ModGameEvents.getRequiredToolForBlock(middleBlockState);
                if (requiredTool != null && ModGameEvents.isValidBlockForTool(middleBlockState, requiredTool)) {
                    boolean middleBlockNeedsAdvancedTool;
                    boolean bl = middleBlockNeedsAdvancedTool = middleBlockState.is(BlockTags.NEEDS_DIAMOND_TOOL) || middleBlockState.is(Tags.Blocks.NEEDS_NETHERITE_TOOL);
                    if (HARVESTED_BLOCKS.contains(initialBlockPos)) {
                        return;
                    }
                    List<BlockPos> affectedPositions = VibraniumMaceItem.getBlocksToBeDestroyed(1, initialBlockPos, (Player)serverPlayer);
                    affectedPositions.remove(initialBlockPos);
                    DeferredHolder<Enchantment, Enchantment> universalBreakerEnchantmentHolder = EnchantmentInit.UNIVERSAL_BREAKER;
                    int enchantmentLevel = mainHandItem.getEnchantmentLevel(universalBreakerEnchantmentHolder);
                    boolean hasUniversalBreaker = enchantmentLevel > 0;
                    for (BlockPos pos : affectedPositions) {
                        BlockState targetBlockState = level.getBlockState(pos);
                        if (!hasUniversalBreaker && (!middleBlockNeedsAdvancedTool || !ModGameEvents.isValidBlockForTool(targetBlockState, requiredTool)) && (middleBlockNeedsAdvancedTool || targetBlockState.is(BlockTags.NEEDS_DIAMOND_TOOL) || targetBlockState.is(Tags.Blocks.NEEDS_NETHERITE_TOOL) || !ModGameEvents.isValidBlockForTool(targetBlockState, requiredTool))) continue;
                        HARVESTED_BLOCKS.add(pos);
                        if (((Boolean)ServerConfig.USE_FAST_MODE.get()).booleanValue()) {
                            serverPlayer.gameMode.destroyBlock(pos);
                        } else {
                            level.destroyBlock(pos, false);
                            Block.getDrops((BlockState)targetBlockState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null, (Entity)player, (ItemStack)mainHandItem).forEach(drop -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop));
                            mainHandItem.hurtAndBreak(1, (LivingEntity)serverPlayer, EquipmentSlot.MAINHAND);
                        }
                        HARVESTED_BLOCKS.remove(pos);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState blockState = level.getBlockState(pos);
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.getItem() == ItemInit.RAW_VIBRANIUM.get()) {
            boolean transformed = false;
            if (blockState.is(Blocks.DIRT)) {
                level.setBlock(pos, ((EVDirtBlock)((Object)BlockInit.ENRICHED_VIBRANIUM_DIRT.get())).defaultBlockState(), 3);
                transformed = true;
            } else if (blockState.is(Blocks.FARMLAND)) {
                int moisture = (Integer)blockState.getValue((Property)FarmBlock.MOISTURE);
                BlockState enrichedFarmlandState = (BlockState)((Block)BlockInit.ENRICHED_VIBRANIUM_FARMLAND.get()).defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(moisture));
                level.setBlock(pos, enrichedFarmlandState, 3);
                transformed = true;
            }
            if (transformed) {
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
                level.playSound(null, pos, SoundEvents.MUD_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Arrow arrow;
        ItemStack activeItem;
        Player player;
        EntityHitResult entityHitResult;
        Entity targetEntity;
        HitResult hitResult = event.getRayTraceResult();
        Projectile projectile = event.getProjectile();
        if (hitResult.getType() == HitResult.Type.ENTITY && (targetEntity = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof Player && (player = (Player)targetEntity).isBlocking() && (activeItem = player.getUseItem()).getItem() == ItemInit.VIBRANIUM_SHIELD.get() && projectile instanceof Arrow && ModGameEvents.isProjectileInFront(player, (Projectile)(arrow = (Arrow)projectile))) {
            event.setCanceled(false);
            ModGameEvents.shootArrowBack(player, arrow);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Entity attacker;
        ItemStack activeItem;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isBlocking() && (activeItem = player.getUseItem()).getItem() == ItemInit.VIBRANIUM_SHIELD.get() && (attacker = event.getSource().getDirectEntity()) instanceof LivingEntity && ModGameEvents.isAttackInFront(player, attacker)) {
            ModGameEvents.knockbackAttacker(player, (LivingEntity)attacker);
            event.getContainer().setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState blockState = event.getState();
        Player player = event.getPlayer();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (blockState.is((Block)BlockInit.DEPPSLATE_VIBRANIUM_ORE.get()) && !player.isCreative()) {
            List golems = level.getEntitiesOfClass(VibraGolemEntity.class, player.getBoundingBox().inflate(20.0));
            for (VibraGolemEntity vibraGolem : golems) {
                if (vibraGolem.isTame()) continue;
                vibraGolem.setTarget((LivingEntity)player);
                vibraGolem.setAggressive(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        boolean hasRawVibranium = false;
        if (!player.isCreative()) {
            for (ItemStack itemStack : player.getInventory()) {
                if (itemStack.getItem() != ItemInit.RAW_VIBRANIUM.get()) continue;
                hasRawVibranium = true;
                break;
            }
            if (hasRawVibranium) {
                List golems = level2.getEntitiesOfClass(VibraGolemEntity.class, player.getBoundingBox().inflate(20.0));
                for (VibraGolemEntity vibraGolem : golems) {
                    if (vibraGolem.isTame()) continue;
                    vibraGolem.setTarget((LivingEntity)player);
                    vibraGolem.setAggressive(true);
                }
            }
        }
        if (!player.isEyeInFluid(FluidTags.WATER) && ModGameEvents.isEquipped(player, (Item)ItemInit.VIBRANIUM_TURTLE_HELMET.get())) {
            ModGameEvents.vibraniumTurtleHelmetTick(player);
        }
    }

    private static TagKey<Block> getRequiredToolForBlock(BlockState state) {
        if (state.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return BlockTags.MINEABLE_WITH_PICKAXE;
        }
        if (state.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
            return BlockTags.MINEABLE_WITH_SHOVEL;
        }
        if (state.is(BlockTags.MINEABLE_WITH_AXE)) {
            return BlockTags.MINEABLE_WITH_AXE;
        }
        return null;
    }

    public static boolean isValidBlockForTool(BlockState state, TagKey<Block> requiredTool) {
        return state.isSolidRender() && state.is(requiredTool) && state.getBlock() != Blocks.AIR;
    }

    private static boolean isProjectileInFront(Player player, Projectile projectile) {
        Vec3 playerToProjectile = projectile.position().subtract(player.position()).normalize();
        Vec3 playerLookDirection = player.getLookAngle().normalize();
        double dotProduct = playerLookDirection.dot(playerToProjectile);
        return dotProduct > 0.0;
    }

    private static boolean isAttackInFront(Player player, Entity attacker) {
        Vec3 playerToAttacker = attacker.position().subtract(player.position()).normalize();
        Vec3 playerLookDirection = player.getLookAngle().normalize();
        double dotProduct = playerLookDirection.dot(playerToAttacker);
        return dotProduct > 0.0;
    }

    private static void shootArrowBack(Player player, Arrow originalArrow) {
        Player shooter;
        Arrow newArrow = new Arrow(EntityType.ARROW, player.level());
        newArrow.setCritArrow(originalArrow.isCritArrow());
        newArrow.setRemainingFireTicks(originalArrow.getRemainingFireTicks());
        newArrow.setOwner((Entity)player);
        newArrow.setPos(originalArrow.getX(), originalArrow.getY(), originalArrow.getZ());
        Vec3 lookDirection = player.getLookAngle();
        Vec3 adjustedDirection = new Vec3(lookDirection.x, lookDirection.y + 0.15, lookDirection.z);
        newArrow.shoot(adjustedDirection.x, adjustedDirection.y, adjustedDirection.z, 1.0f, 1.0f);
        originalArrow.discard();
        Entity owner = originalArrow.getOwner();
        newArrow.pickup = owner instanceof Player ? ((shooter = (Player)owner).getUseItem().getItem() instanceof BowItem ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED) : (owner == null ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.CREATIVE_ONLY);
        player.level().addFreshEntity((Entity)newArrow);
    }

    private static void knockbackAttacker(Player player, LivingEntity attacker) {
        double strength = 1.25;
        Vec3 knockbackDirection = new Vec3(attacker.getX() - player.getX(), 0.0, attacker.getZ() - player.getZ()).normalize();
        attacker.push(knockbackDirection.x * strength, 0.5, knockbackDirection.z * strength);
    }

    private static void vibraniumTurtleHelmetTick(Player player) {
        player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 405, 0, false, false, true));
    }

    private static boolean isEquipped(Player player, Item item) {
        for (EquipmentSlot slot : EquipmentSlot.VALUES) {
            ItemStack stack = player.getItemBySlot(slot);
            Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
            if (!stack.is(item) || equippable == null || equippable.slot() != slot) continue;
            return true;
        }
        return false;
    }
}

