/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init;

import de.bigbull.vibranium.init.ItemInit;
import de.bigbull.vibranium.init.ParticleInit;
import de.bigbull.vibranium.init.TypesInit;
import de.bigbull.vibranium.init.custom.block.EVDirtBlock;
import de.bigbull.vibranium.init.custom.block.EVFarmlandBlock;
import de.bigbull.vibranium.init.custom.block.HSHBushBlock;
import de.bigbull.vibranium.init.custom.block.tree.EVTree;
import de.bigbull.vibranium.init.custom.block.tree.SoulTreeSaplingBlock;
import de.bigbull.vibranium.init.custom.block.tree.VibraniumRotatedPillarBlock;
import de.bigbull.vibranium.init.custom.block.vibraniumcrystal.BuddingVibraniumBlock;
import de.bigbull.vibranium.init.custom.block.vibraniumcrystal.VibraniumClusterBlock;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockInit {
    public static DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"vibranium");
    public static final DeferredBlock<Block> BLOCK_OF_RAW_VIBRANIUM = BlockInit.registerBlock("block_of_raw_vibranium", properties -> new Block(properties.instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_BLUE).requiresCorrectToolForDrops().strength(6.0f, 1200.0f)));
    public static final DeferredBlock<Block> DEPPSLATE_VIBRANIUM_ORE = BlockInit.registerBlock("deepslate_vibranium_ore", properties -> new Block(properties.mapColor(MapColor.DEEPSLATE).strength(12.0f, 1200.0f).sound(SoundType.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> VIBRANIUM_BLOCK = BlockInit.registerBlock("vibranium_block", properties -> new Block(properties.mapColor(MapColor.COLOR_BLUE).strength(50.0f, 1200.0f).sound(SoundType.NETHERITE_BLOCK).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> HEART_SHAPED_HERB_BUSH = BLOCKS.registerBlock("heart_shaped_herb_bush", (T properties) -> new HSHBushBlock(properties.mapColor(MapColor.PLANT).randomTicks().noCollision().sound(SoundType.SWEET_BERRY_BUSH).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<EVDirtBlock> ENRICHED_VIBRANIUM_DIRT = BlockInit.registerBlock("enriched_vibranium_dirt", properties -> new EVDirtBlock(properties.mapColor(MapColor.DIRT).strength(0.6f).sound(SoundType.GRAVEL).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> ENRICHED_VIBRANIUM_FARMLAND = BlockInit.registerBlock("enriched_vibranium_farmland", properties -> new EVFarmlandBlock(properties.mapColor(MapColor.DIRT).randomTicks().strength(0.6f).sound(SoundType.GRAVEL).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SOULWOOD_LOG = BlockInit.registerBlock("soulwood_log", properties -> new VibraniumRotatedPillarBlock(properties.mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor.WOOD : MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.CHERRY_WOOD)));
    public static final DeferredBlock<Block> SOULWOOD_WOOD = BlockInit.registerBlock("soulwood_wood", properties -> new VibraniumRotatedPillarBlock(properties.mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.CHERRY_WOOD)));
    public static final DeferredBlock<Block> STRIPPED_SOULWOOD_LOG = BlockInit.registerBlock("stripped_soulwood_log", properties -> new VibraniumRotatedPillarBlock(properties.mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.CHERRY_WOOD)));
    public static final DeferredBlock<Block> STRIPPED_SOULWOOD_WOOD = BlockInit.registerBlock("stripped_soulwood_wood", properties -> new VibraniumRotatedPillarBlock(properties.mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.CHERRY_WOOD)));
    public static final DeferredBlock<Block> SOULWOOD_LEAVES = BlockInit.registerBlock("soulwood_leaves", properties -> new UntintedParticleLeavesBlock(0.1f, (ParticleOptions)ParticleInit.SOULWOOD_LEAVES.get(), properties.mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating((state, reader, pos) -> false).isViewBlocking((state, reader, pos) -> false).pushReaction(PushReaction.DESTROY).isRedstoneConductor((state, reader, pos) -> false)));
    public static final DeferredBlock<Block> SOULWOOD_SAPLING = BlockInit.registerBlock("soulwood_sapling", properties -> new SoulTreeSaplingBlock(EVTree.SOUL_TREE, properties.mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.CHERRY_SAPLING).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> SOULWOOD_PLANKS = BlockInit.registerBlock("soulwood_planks", properties -> new VibraniumRotatedPillarBlock(properties.mapColor(MapColor.TERRACOTTA_BLUE).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD)));
    public static final DeferredBlock<StairBlock> SOULWOOD_STAIRS = BlockInit.registerBlock("soulwood_stairs", properties -> new StairBlock(((Block)SOULWOOD_PLANKS.get()).defaultBlockState(), properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD)));
    public static final DeferredBlock<SlabBlock> SOULWOOD_SLAB = BlockInit.registerBlock("soulwood_slab", properties -> new SlabBlock(properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD)));
    public static final DeferredBlock<PressurePlateBlock> SOULWOOD_PRESSURE_PLATE = BlockInit.registerBlock("soulwood_pressure_plate", properties -> new PressurePlateBlock(TypesInit.SOULWOOD_BLOCKSETTYPE, properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.8f).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<ButtonBlock> SOULWOOD_BUTTON = BlockInit.registerBlock("soulwood_button", properties -> new ButtonBlock(TypesInit.SOULWOOD_BLOCKSETTYPE, 30, properties.noCollision().strength(0.8f).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<FenceBlock> SOULWOOD_FENCE = BlockInit.registerBlock("soulwood_fence", properties -> new FenceBlock(properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD)));
    public static final DeferredBlock<FenceGateBlock> SOULWOOD_FENCE_GATE = BlockInit.registerBlock("soulwood_fence_gate", properties -> new FenceGateBlock(TypesInit.SOULWOOD_WOODTYPE, properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f)));
    public static final DeferredBlock<DoorBlock> SOULWOOD_DOOR = BlockInit.registerBlock("soulwood_door", properties -> new DoorBlock(TypesInit.SOULWOOD_BLOCKSETTYPE, properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<TrapDoorBlock> SOULWOOD_TRAPDOOR = BlockInit.registerBlock("soulwood_trapdoor", properties -> new TrapDoorBlock(TypesInit.SOULWOOD_BLOCKSETTYPE, properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never)));
    public static final DeferredBlock<StandingSignBlock> SOULWOOD_SIGN = BLOCKS.registerBlock("soulwood_sign", (T properties) -> new StandingSignBlock(TypesInit.SOULWOOD_WOODTYPE, properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).forceSolidOn().strength(1.0f).noCollision()));
    public static final DeferredBlock<WallSignBlock> SOULWOOD_WALL_SIGN = BLOCKS.registerBlock("soulwood_wall_sign", (T properties) -> new WallSignBlock(TypesInit.SOULWOOD_WOODTYPE, properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).forceSolidOn().strength(1.0f).noCollision()));
    public static final DeferredBlock<CeilingHangingSignBlock> SOULWOOD_HANGING_SIGN = BLOCKS.registerBlock("soulwood_hanging_sign", (T properties) -> new CeilingHangingSignBlock(TypesInit.SOULWOOD_WOODTYPE, properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).forceSolidOn().strength(1.0f).noCollision()));
    public static final DeferredBlock<WallHangingSignBlock> SOULWOOD_WALL_HANGING_SIGN = BLOCKS.registerBlock("soulwood_wall_hanging_sign", (T properties) -> new WallHangingSignBlock(TypesInit.SOULWOOD_WOODTYPE, properties.mapColor(((Block)SOULWOOD_PLANKS.get()).defaultMapColor()).forceSolidOn().strength(1.0f).noCollision()));
    public static final DeferredBlock<FlowerPotBlock> POTTED_SOULWOOD_SAPLING = BLOCKS.registerBlock("potted_soulwood_sapling", (T properties) -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, SOULWOOD_SAPLING, properties.instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> VIBRANIUM_CRYSTAL_BLOCK = BlockInit.registerBlock("vibranium_crystal_block", properties -> new AmethystBlock(properties.mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BUDDING_VIBRANIUM_CRYSTAL = BlockInit.registerBlock("budding_vibranium_crystal", properties -> new BuddingVibraniumBlock(properties.mapColor(MapColor.COLOR_CYAN).randomTicks().strength(5.0f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> VIBRANIUM_CLUSTER = BlockInit.registerBlock("vibranium_cluster", properties -> new VibraniumClusterBlock(7.0f, 3.0f, properties.mapColor(MapColor.COLOR_CYAN).forceSolidOn().noOcclusion().sound(SoundType.AMETHYST_CLUSTER).strength(5.0f).lightLevel(state -> 8).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> LARGE_VIBRANIUM_BUD = BlockInit.registerBlock("large_vibranium_bud", properties -> new VibraniumClusterBlock(5.0f, 3.0f, properties.mapColor(MapColor.COLOR_PURPLE).forceSolidOn().noOcclusion().sound(SoundType.LARGE_AMETHYST_BUD).strength(1.5f).lightLevel(state -> 6).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> MEDIUM_VIBRANIUM_BUD = BlockInit.registerBlock("medium_vibranium_bud", properties -> new VibraniumClusterBlock(4.0f, 3.0f, properties.mapColor(MapColor.COLOR_PURPLE).forceSolidOn().noOcclusion().sound(SoundType.MEDIUM_AMETHYST_BUD).strength(1.5f).lightLevel(state -> 4).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> SMALL_VIBRANIUM_BUD = BlockInit.registerBlock("small_vibranium_bud", properties -> new VibraniumClusterBlock(3.0f, 4.0f, properties.mapColor(MapColor.COLOR_PURPLE).forceSolidOn().noOcclusion().sound(SoundType.SMALL_AMETHYST_BUD).strength(1.5f).lightLevel(state -> 2).pushReaction(PushReaction.DESTROY)));

    private static <B extends Block> DeferredBlock<B> registerBlock(String name, Function<BlockBehaviour.Properties, ? extends B> func) {
        DeferredBlock toReturn = BLOCKS.registerBlock(name, func);
        BlockInit.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)name)))));
    }
}

