/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HSHEffect
extends MobEffect {
    private final Map<Player, Float> damageTracker = new HashMap<Player, Float>();
    private static final float DAMAGE_THRESHOLD = 10.0f;
    private static final float BASE_PUSH_DAMAGE = 4.0f;
    private static final double BASE_PUSH_RADIUS = 2.5;
    private static final double BASE_PUSH_STRENGTH = 1.5;

    public HSHEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void onMobHurt(ServerLevel level, LivingEntity entity, int amplifier, DamageSource source, float damage) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isDeadOrDying()) {
                this.damageTracker.remove(player);
                return;
            }
            if (!(source.getEntity() instanceof LivingEntity)) {
                return;
            }
            float baseDamage = (float)player.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
            float adjustedDamage = Math.max(damage, baseDamage / 2.0f);
            this.accumulateDamage(player, adjustedDamage);
            if (this.damageTracker.getOrDefault(player, Float.valueOf(0.0f)).floatValue() >= 10.0f) {
                double pushStrength = 1.5 + (double)amplifier * 0.5;
                double pushRadius = 2.5 + (double)amplifier * 2.5;
                float pushDamage = (float)(4.0 + (double)amplifier * 2.0);
                this.applyPushEffect(player, pushStrength, pushRadius, pushDamage);
                this.damageTracker.put(player, Float.valueOf(0.0f));
            }
        }
    }

    private void accumulateDamage(Player player, float damage) {
        float accumulatedDamage = this.damageTracker.getOrDefault(player, Float.valueOf(0.0f)).floatValue();
        this.damageTracker.put(player, Float.valueOf(accumulatedDamage += damage));
    }

    private void applyPushEffect(Player player, double strength, double radius, float damage) {
        Level entity2;
        int particleCount = 120;
        List entities = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(radius));
        for (Level entity2 : entities) {
            if (entity2 == player) continue;
            Vec3 direction = entity2.position().subtract(player.position()).normalize().scale(strength);
            entity2.setDeltaMovement(entity2.getDeltaMovement().add(direction.x, 0.5, direction.z));
            entity2.hurtMarked = true;
            DamageSource pushDamageSource = player.damageSources().playerAttack(player);
            Level level = entity2.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            entity2.hurtServer(serverLevel, pushDamageSource, damage);
        }
        entity2 = player.level();
        if (entity2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity2;
            for (int i = 0; i < particleCount; ++i) {
                double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
                double xParticleOffset = radius * Math.cos(angleOffset);
                double zParticleOffset = radius * Math.sin(angleOffset);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, player.getX() + xParticleOffset, player.getY() - 0.1, player.getZ() + zParticleOffset, 1, 0.0, 0.05, 0.0, 0.05);
            }
        }
        player.level().playSound(null, player.blockPosition(), SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

