/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.common.EventBusSubscriber;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT})
public class ShieldRenderer
implements SpecialModelRenderer<DataComponentMap> {
    private final MaterialSet materials;
    private final ShieldModel model;
    public static final Material VIBRANIUM_SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)"entity/vibranium_shield_base"));
    public static final Material VIBRANIUM_SHIELD_BASE_NO_PATTERN = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)"vibranium", (String)"entity/vibranium_shield_base_nopattern"));

    public ShieldRenderer(MaterialSet materials, ShieldModel model) {
        this.materials = materials;
        this.model = model;
    }

    public void submit(@Nullable DataComponentMap dataComponents, ItemDisplayContext context, PoseStack poseStack, SubmitNodeCollector collector, int p_386748_, int p_388858_, boolean p_387642_, int p_451675_) {
        BannerPatternLayers bannerpatternlayers = dataComponents != null ? (BannerPatternLayers)dataComponents.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY) : BannerPatternLayers.EMPTY;
        DyeColor dyecolor = dataComponents != null ? (DyeColor)dataComponents.get(DataComponents.BASE_COLOR) : null;
        boolean flag = !bannerpatternlayers.layers().isEmpty() || dyecolor != null;
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        Material material = flag ? VIBRANIUM_SHIELD_BASE : VIBRANIUM_SHIELD_BASE_NO_PATTERN;
        collector.submitModelPart(this.model.handle(), poseStack, this.model.renderType(material.atlasLocation()), p_386748_, p_388858_, this.materials.get(material), false, false, -1, null, p_451675_);
        if (flag) {
            BannerRenderer.submitPatterns((MaterialSet)this.materials, (PoseStack)poseStack, (SubmitNodeCollector)collector, (int)p_386748_, (int)p_388858_, (Model)this.model, (Object)Unit.INSTANCE, (Material)material, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyecolor, DyeColor.WHITE), (BannerPatternLayers)bannerpatternlayers, (boolean)p_387642_, null, (int)p_451675_);
        } else {
            collector.submitModelPart(this.model.plate(), poseStack, this.model.renderType(material.atlasLocation()), p_386748_, p_388858_, this.materials.get(material), false, p_387642_, -1, null, p_451675_);
        }
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> p_428206_) {
        PoseStack posestack = new PoseStack();
        posestack.scale(1.0f, -1.0f, -1.0f);
        this.model.root().getExtentsForGui(posestack, p_428206_);
    }

    @Nullable
    public DataComponentMap extractArgument(ItemStack stack) {
        return stack.immutableComponents();
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final Unbaked INSTANCE = new Unbaked();
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)INSTANCE);

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext bakingContext) {
            return new ShieldRenderer(bakingContext.materials(), new ShieldModel(bakingContext.entityModelSet().bakeLayer(ModelLayers.SHIELD)));
        }
    }
}

