/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.bigbull.vibranium.init.FeatureInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class SoulTreeTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<SoulTreeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> SoulTreeTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.codec((int)1, (int)4).fieldOf("branch_count").forGetter(placer -> placer.branchCount), (App)IntProvider.codec((int)2, (int)16).fieldOf("branch_horizontal_length").forGetter(placer -> placer.branchHorizontalLength), (App)IntProvider.codec((int)-16, (int)0).fieldOf("branch_start_offset_from_top").forGetter(placer -> placer.branchStartOffsetFromTop), (App)IntProvider.codec((int)-16, (int)16).fieldOf("branch_end_offset_from_top").forGetter(placer -> placer.branchEndOffsetFromTop))).apply((Applicative)instance, SoulTreeTrunkPlacer::new));
    private final IntProvider branchCount;
    private final IntProvider branchHorizontalLength;
    private final IntProvider branchStartOffsetFromTop;
    private final IntProvider branchEndOffsetFromTop;

    public SoulTreeTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider branchCount, IntProvider branchHorizontalLength, IntProvider branchStartOffsetFromTop, IntProvider branchEndOffsetFromTop) {
        super(baseHeight, heightRandA, heightRandB);
        this.branchCount = branchCount;
        this.branchHorizontalLength = branchHorizontalLength;
        this.branchStartOffsetFromTop = branchStartOffsetFromTop;
        this.branchEndOffsetFromTop = branchEndOffsetFromTop;
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)FeatureInit.SOUL_TREE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int trunkHeight, BlockPos pos, TreeConfiguration config) {
        SoulTreeTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeLog(level, blockSetter, random, pos.above(i), config);
        }
        ArrayList<FoliagePlacer.FoliageAttachment> attachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        attachments.add(new FoliagePlacer.FoliageAttachment(pos.above(trunkHeight), 0, false));
        ArrayList<Direction> possibleDirections = new ArrayList<Direction>(List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST));
        int branches = this.branchCount.sample(random);
        Collections.shuffle(possibleDirections, new Random(random.nextLong()));
        for (int i = 0; i < branches; ++i) {
            int branchStartHeight;
            Direction direction = (Direction)possibleDirections.get(i);
            int branchStartOffset = this.branchStartOffsetFromTop.sample(random);
            attachments.add(this.generateBranch(level, blockSetter, random, trunkHeight, pos, config, direction, branchStartHeight, (branchStartHeight = trunkHeight - 1 + branchStartOffset) < trunkHeight - 1));
        }
        return attachments;
    }

    private FoliagePlacer.FoliageAttachment generateBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int trunkHeight, BlockPos pos, TreeConfiguration config, Direction direction, int branchStartHeight, boolean extraLength) {
        Direction verticalDirection;
        BlockPos.MutableBlockPos mutablePos = pos.mutable().move(Direction.UP, branchStartHeight);
        int branchEndOffset = this.branchEndOffsetFromTop.sample(random);
        int branchHeight = trunkHeight - 1 + branchEndOffset;
        boolean flag = extraLength || branchHeight < branchStartHeight;
        int branchLength = this.branchHorizontalLength.sample(random) + (flag ? 1 : 0);
        BlockPos branchEndPos = pos.relative(direction, branchLength).above(branchHeight);
        int steps = flag ? 2 : 1;
        Function<BlockState, BlockState> axisSetter = state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis());
        for (int i = 0; i < steps; ++i) {
            this.placeLog(level, blockSetter, random, (BlockPos)mutablePos.move(direction), config, axisSetter);
        }
        Direction direction2 = verticalDirection = branchEndPos.getY() > mutablePos.getY() ? Direction.UP : Direction.DOWN;
        while (!mutablePos.equals((Object)branchEndPos)) {
            int distance = mutablePos.distManhattan((Vec3i)branchEndPos);
            float chance = (float)Math.abs(branchEndPos.getY() - mutablePos.getY()) / (float)distance;
            boolean moveVertically = random.nextFloat() < chance;
            mutablePos.move(moveVertically ? verticalDirection : direction);
            this.placeLog(level, blockSetter, random, (BlockPos)mutablePos, config, moveVertically ? Function.identity() : axisSetter);
        }
        return new FoliagePlacer.FoliageAttachment(branchEndPos.above(), 0, false);
    }
}

